/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.LineRange;
import edu.hm.hafner.analysis.LineRangeList;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public class FindBugsParser
extends IssueParser {
    private static final long serialVersionUID = 8306319007761954027L;
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private static final int HIGH_PRIORITY_LOWEST_RANK = 4;
    private static final int NORMAL_PRIORITY_LOWEST_RANK = 9;
    private final PriorityProperty priorityProperty;

    public FindBugsParser(PriorityProperty priorityProperty) {
        this.priorityProperty = priorityProperty;
    }

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException {
        ArrayList<String> sources = new ArrayList<String>();
        String moduleRoot = StringUtils.substringBefore((String)readerFactory.getFileName(), (String)"/target/");
        sources.add(moduleRoot + "/src/main/java");
        sources.add(moduleRoot + "/src/test/java");
        sources.add(moduleRoot + "/src");
        return this.parse(readerFactory, sources, new IssueBuilder());
    }

    @VisibleForTesting
    Report parse(ReaderFactory readerFactory, Collection<String> sources, IssueBuilder builder) throws ParsingException {
        HashMap<String, String> hashToMessageMapping = new HashMap<String, String>();
        HashMap<String, String> categories = new HashMap<String, String>();
        try (Reader input = readerFactory.create();){
            List<XmlBugInstance> bugs = this.preParse(input);
            for (XmlBugInstance bug : bugs) {
                hashToMessageMapping.put(bug.getInstanceHash(), bug.getMessage());
                categories.put(bug.getType(), bug.getCategory());
            }
        }
        catch (IOException | SAXException exception) {
            throw new ParsingException(exception);
        }
        return this.parse(readerFactory, sources, builder, hashToMessageMapping, categories);
    }

    /*
     * Exception decompiling
     */
    private Report parse(ReaderFactory readerFactory, Collection<String> sources, IssueBuilder builder, Map<String, String> hashToMessageMapping, Map<String, String> categories) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Report convertBugsToIssues(Collection<String> sources, IssueBuilder builder, Map<String, String> hashToMessageMapping, Map<String, String> categories, SortedBugCollection collection, Project project) {
        project.addSourceDirs(sources);
        try (SourceFinder sourceFinder = new SourceFinder(project);){
            if (StringUtils.isNotBlank((CharSequence)project.getProjectName())) {
                builder.setModuleName(project.getProjectName());
            }
            Collection bugs = collection.getCollection();
            Report report = new Report();
            for (BugInstance warning : bugs) {
                SourceLineAnnotation sourceLine = warning.getPrimarySourceLineAnnotation();
                String message = warning.getMessage();
                String type = warning.getType();
                String category = categories.get(type);
                if (category == null) {
                    category = warning.getBugPattern().getCategory();
                }
                builder.setSeverity(this.getPriority(warning)).setMessage(this.createMessage(hashToMessageMapping, warning, message)).setCategory(category).setType(type).setLineStart(sourceLine.getStartLine()).setLineEnd(sourceLine.getEndLine()).setFileName(this.findSourceFile(sourceFinder, sourceLine)).setPackageName(warning.getPrimaryClass().getPackageName()).setFingerprint(warning.getInstanceHash());
                this.setAffectedLines(warning, builder, new LineRange(sourceLine.getStartLine(), sourceLine.getEndLine()));
                report.add(builder.build());
            }
            Report report2 = report;
            return report2;
        }
    }

    @VisibleForTesting
    List<XmlBugInstance> preParse(Reader file) throws SAXException, IOException {
        SecureDigester digester = new SecureDigester(FindBugsParser.class);
        String rootXPath = "BugCollection/BugInstance";
        digester.addObjectCreate(rootXPath, XmlBugInstance.class);
        digester.addSetProperties(rootXPath);
        String fileXPath = rootXPath + "/LongMessage";
        digester.addCallMethod(fileXPath, "setMessage", 0);
        digester.addSetNext(rootXPath, "add", Object.class.getName());
        ArrayList<XmlBugInstance> bugs = new ArrayList<XmlBugInstance>();
        digester.push(bugs);
        digester.parse(file);
        return bugs;
    }

    private String createMessage(Map<String, String> hashToMessageMapping, BugInstance warning, String message) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)hashToMessageMapping.get(warning.getInstanceHash()), (CharSequence)message);
    }

    private Severity getPriority(BugInstance warning) {
        if (this.priorityProperty == PriorityProperty.RANK) {
            return this.getPriorityByRank(warning);
        }
        return this.getPriorityByPriority(warning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedBugCollection readXml(Reader file) throws IOException, DocumentException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(FindBugsParser.class.getClassLoader());
            SortedBugCollection collection = new SortedBugCollection();
            collection.readXML(file);
            SortedBugCollection sortedBugCollection = collection;
            return sortedBugCollection;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private void setAffectedLines(BugInstance warning, IssueBuilder builder, LineRange primary) {
        Iterator annotationIterator = warning.annotationIterator();
        LineRangeList lineRanges = new LineRangeList();
        while (annotationIterator.hasNext()) {
            SourceLineAnnotation annotation;
            LineRange lineRange;
            BugAnnotation bugAnnotation = (BugAnnotation)annotationIterator.next();
            if (!(bugAnnotation instanceof SourceLineAnnotation) || lineRanges.contains(lineRange = new LineRange((annotation = (SourceLineAnnotation)bugAnnotation).getStartLine(), annotation.getEndLine())) || primary.equals(lineRange)) continue;
            lineRanges.add(lineRange);
        }
        builder.setLineRanges(lineRanges);
    }

    private String findSourceFile(SourceFinder sourceFinder, SourceLineAnnotation sourceLine) {
        try {
            SourceFile sourceFile = sourceFinder.findSourceFile(sourceLine);
            return sourceFile.getFullFileName();
        }
        catch (IOException ignored) {
            return sourceLine.getPackageName().replace(DOT, SLASH) + SLASH + sourceLine.getSourceFile();
        }
    }

    private Severity getPriorityByRank(BugInstance warning) {
        int rank = warning.getBugRank();
        if (rank <= 4) {
            return Severity.WARNING_HIGH;
        }
        if (rank <= 9) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }

    private Severity getPriorityByPriority(BugInstance warning) {
        switch (warning.getPriority()) {
            case 1: {
                return Severity.WARNING_HIGH;
            }
            case 2: {
                return Severity.WARNING_NORMAL;
            }
        }
        return Severity.WARNING_LOW;
    }

    public static class XmlBugInstance {
        @Nullable
        private String instanceHash;
        @Nullable
        private String message;
        @Nullable
        private String type;
        @Nullable
        private String category;

        @Nullable
        public String getInstanceHash() {
            return this.instanceHash;
        }

        public void setInstanceHash(String instanceHash) {
            this.instanceHash = instanceHash;
        }

        @Nullable
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Nullable
        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }
    }

    public static enum PriorityProperty {
        CONFIDENCE,
        RANK;

    }
}

