/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class GccParser
extends RegexpLineParser {
    private static final long serialVersionUID = 2020182274225690532L;
    static final String GCC_ERROR = "GCC error";
    static final String LINKER_ERROR = "Linker error";
    private static final String GCC_WARNING_PATTERN = "^(?:\\s*(?:\\[.*\\]\\s*)?([^ ]*\\.[chpimxsola0-9]+):(?:(\\d*):(?:\\d*:)*\\s*(?:(warning|error|note)\\s*:|\\s*(.*))|\\s*(undefined reference to.*))(.*)|.*ld:\\s*(.*-l(.*)))$";

    public GccParser() {
        super(GCC_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        Severity priority;
        if (StringUtils.isNotBlank((CharSequence)matcher.group(7))) {
            return builder.setFileName(matcher.group(8)).setLineStart(0).setCategory(LINKER_ERROR).setMessage(matcher.group(7)).setSeverity(Severity.WARNING_HIGH).buildOptional();
        }
        String fileName = matcher.group(1);
        if (StringUtils.contains((CharSequence)fileName, (CharSequence)"cleartool")) {
            return Optional.empty();
        }
        if ("warning".equalsIgnoreCase(matcher.group(3))) {
            priority = Severity.WARNING_NORMAL;
        } else if ("error".equalsIgnoreCase(matcher.group(3))) {
            priority = Severity.WARNING_HIGH;
        } else if ("note".equalsIgnoreCase(matcher.group(3))) {
            priority = Severity.WARNING_LOW;
        } else {
            if (StringUtils.isNotBlank((CharSequence)matcher.group(4))) {
                if (matcher.group(4).contains("instantiated from here")) {
                    return Optional.empty();
                }
                return builder.setFileName(fileName).setLineStart(matcher.group(2)).setCategory(GCC_ERROR).setMessage(StringEscapeUtils.escapeXml10((String)matcher.group(4))).setSeverity(Severity.WARNING_HIGH).buildOptional();
            }
            return builder.setFileName(fileName).setLineStart(0).setCategory(GCC_ERROR).setMessage(StringEscapeUtils.escapeXml10((String)matcher.group(5))).setSeverity(Severity.WARNING_HIGH).buildOptional();
        }
        return builder.setFileName(fileName).setLineStart(matcher.group(2)).setCategory("GCC " + matcher.group(3)).setMessage(StringEscapeUtils.escapeXml10((String)matcher.group(6))).setSeverity(priority).buildOptional();
    }
}

