/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Categories;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class JavacParser
extends LookaheadParser {
    private static final long serialVersionUID = 7199325311690082782L;
    private static final String ERRORPRONE_URL_PATTERN = "\\s+\\(see https?://\\S+\\s*\\)";
    private static final String JAVAC_WARNING_PATTERN = "^(?:\\S+\\s+)?(?:(?:\\[(WARNING|ERROR)\\]|w:)\\s+)([^\\[\\(]*):\\s*[\\[\\(](\\d+)[.,;]*\\s?(\\d+)?[\\]\\)]\\s*:?(?:\\[(\\w+)\\])?\\s*(.*)$";

    public JavacParser() {
        super(JAVAC_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("[") || line.contains("w:");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) throws ParsingException {
        if (lookahead.hasNext(ERRORPRONE_URL_PATTERN)) {
            return Optional.empty();
        }
        String type = matcher.group(1);
        if ("ERROR".equals(type)) {
            builder.setSeverity(Severity.ERROR);
        } else {
            builder.setSeverity(Severity.WARNING_NORMAL);
        }
        String message = matcher.group(6);
        String category = Categories.guessCategoryIfEmpty(matcher.group(5), message);
        return builder.setFileName(matcher.group(2)).setLineStart(matcher.group(3)).setColumnStart(matcher.group(4)).setCategory(category).setMessage(message).buildOptional();
    }
}

