/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.JsonBaseParser;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonParser
extends JsonBaseParser {
    private static final long serialVersionUID = -6494117943149352139L;
    private static final String ISSUES = "issues";

    @Override
    public boolean accepts(ReaderFactory readerFactory) {
        return readerFactory.getFileName().endsWith(".json");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException {
        try (Reader reader = readerFactory.create();){
            JSONObject jsonReport = (JSONObject)new JSONTokener(reader).nextValue();
            Report report = new Report();
            if (jsonReport.has(ISSUES)) {
                JSONArray issues = jsonReport.getJSONArray(ISSUES);
                StreamSupport.stream(issues.spliterator(), false).filter(o -> o instanceof JSONObject).map(o -> this.convertToIssue((JSONObject)o)).filter(Optional::isPresent).map(Optional::get).forEach(report::add);
            }
            Report report2 = report;
            return report2;
        }
        catch (IOException | JSONException e) {
            throw new ParsingException(e);
        }
    }
}

