/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.IntegerParser;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class NagFortranParser
extends LookaheadParser {
    private static final long serialVersionUID = 2072414911276743946L;
    private static final String NAGFOR_MSG_PATTERN = "^(Info|Warning|Questionable|Extension|Obsolescent|Deleted feature used|Error|Runtime Error|Fatal Error|Panic): (.+\\.[^,:\\n]+)(, line (\\d+))?: (.+(\\s+detected at .+)?)";

    public NagFortranParser() {
        super(NAGFOR_MSG_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) throws ParsingException {
        StringBuilder messageBuilder = new StringBuilder(matcher.group(5));
        while (lookahead.hasNext("\\s+ .+")) {
            messageBuilder.append("\n");
            messageBuilder.append(lookahead.next());
        }
        return builder.setFileName(matcher.group(2)).setLineStart(IntegerParser.parseInt(matcher.group(4))).setCategory(matcher.group(1)).setMessage(messageBuilder.toString()).setSeverity(this.mapPriority(matcher.group(1))).buildOptional();
    }

    private Severity mapPriority(String category) {
        switch (category) {
            case "Error": 
            case "Runtime Error": 
            case "Fatal Error": 
            case "Panic": {
                return Severity.WARNING_HIGH;
            }
            case "Info": {
                return Severity.WARNING_LOW;
            }
        }
        return Severity.WARNING_NORMAL;
    }
}

