/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.IntegerParser;
import java.util.Optional;
import java.util.regex.Matcher;

public class PerlCriticParser
extends RegexpLineParser {
    private static final long serialVersionUID = -6481203155449490873L;
    private static final String PERLCRITIC_WARNING_PATTERN = "(?:(.*?):)?(.*)\\s+at\\s+line\\s+(\\d+),\\s+column\\s+(\\d+)\\.\\s*(?:See page[s]?\\s+)?(.*)\\.\\s*\\(?Severity:\\s*(\\d)\\)?";
    private static final int SEVERITY_LOW_LIMIT = 2;
    private static final int SEVERITY_NORMAL_LIMIT = 4;

    public PerlCriticParser() {
        super(PERLCRITIC_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        String filename = matcher.group(1) == null ? "-" : matcher.group(1);
        return builder.setFileName(filename).setLineStart(matcher.group(3)).setColumnStart(matcher.group(4)).setCategory(matcher.group(5)).setMessage(matcher.group(2)).setSeverity(this.checkPriority(IntegerParser.parseInt(matcher.group(6)))).buildOptional();
    }

    private Severity checkPriority(int priority) {
        if (priority < 2) {
            return Severity.WARNING_LOW;
        }
        if (priority < 4) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_HIGH;
    }
}

