/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.Optional;
import java.util.regex.Matcher;

public class PhpParser
extends RegexpLineParser {
    private static final long serialVersionUID = -5154327854315791181L;
    private static final String PHP_WARNING_PATTERN = "^.*(PHP Warning|PHP Notice|PHP Fatal error|PHP Parse error):\\s+(?:(.+ in (.+) on line (\\d+))|(SOAP-ERROR:\\s+.*))$";

    public PhpParser() {
        super(PHP_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("PHP");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        String category = matcher.group(1);
        builder.setCategory(category).setSeverity(this.mapPriority(category));
        if (matcher.group(5) == null) {
            return builder.setFileName(matcher.group(3)).setLineStart(matcher.group(4)).setMessage(matcher.group(2)).buildOptional();
        }
        return builder.setFileName("-").setLineStart(0).setMessage(matcher.group(5)).buildOptional();
    }

    private Severity mapPriority(String category) {
        if (category.contains("Fatal") || category.contains("Parse")) {
            return Severity.WARNING_HIGH;
        }
        return Severity.WARNING_NORMAL;
    }
}

