/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.Optional;
import java.util.regex.Matcher;

public class RobocopyParser
extends RegexpLineParser {
    private static final long serialVersionUID = -671744745118772873L;
    private static final String ROBOCOPY_WARNING_PATTERN = "^(.*)(EXTRA File|New File|same)\\s*(\\d*)\\s*(.*)$";

    public RobocopyParser() {
        super(ROBOCOPY_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        String file = matcher.group(4).split("\\s{11}", -1)[0];
        return builder.setFileName(file).setLineStart(0).setCategory(matcher.group(2)).setMessage(file).setSeverity(Severity.WARNING_NORMAL).buildOptional();
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("        ");
    }
}

