/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Categories;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.Optional;
import java.util.regex.Matcher;

public class SphinxBuildParser
extends RegexpLineParser {
    private static final long serialVersionUID = 1483050615340274588L;
    private static final String SPHINX_BUILD_WARNING_PATTERN = "^([a-zA-Z]:\\\\.*?|/.*?|[^\\/].*?):(?:.* of .*:)?(\\d+|None|): (ERROR|WARNING): (.*)";

    public SphinxBuildParser() {
        super(SPHINX_BUILD_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        String message = matcher.group(4);
        String category = Categories.guessCategoryIfEmpty(matcher.group(3), message);
        return builder.setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setCategory(category).setMessage(message).setSeverity(this.mapPriority(category)).buildOptional();
    }

    private Severity mapPriority(String priority) {
        if ("error".equalsIgnoreCase(priority)) {
            return Severity.WARNING_HIGH;
        }
        return Severity.WARNING_NORMAL;
    }
}

