/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LineRange;
import edu.hm.hafner.analysis.LineRangeList;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.IssuePropertiesParser;
import edu.hm.hafner.util.XmlElementUtil;
import java.io.Serializable;
import java.util.UUID;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlParser
extends IssuePropertiesParser {
    private static final long serialVersionUID = -8099458358775144575L;
    private static final String LINE_RANGES_PATH = "lineRanges/lineRange";
    private final String xmlIssueRoot;
    private static final String DEFAULT_ROOT_PATH = "/issue";

    private String getXmlIssueRoot() {
        return this.xmlIssueRoot;
    }

    public XmlParser() {
        this(DEFAULT_ROOT_PATH);
    }

    public XmlParser(String root) {
        this.xmlIssueRoot = root;
    }

    @Override
    public boolean accepts(ReaderFactory readerFactory) {
        return readerFactory.getFileName().endsWith(".xml");
    }

    @Override
    public Report parse(ReaderFactory readerFactory) {
        try {
            Document doc = readerFactory.readDocument();
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath path = xPathFactory.newXPath();
            NodeList issues = (NodeList)path.evaluate(this.getXmlIssueRoot(), doc, XPathConstants.NODESET);
            IssueBuilder issueBuilder = new IssueBuilder();
            Report report = new Report();
            for (Element issue : XmlElementUtil.nodeListToList(issues)) {
                issueBuilder.setId(this.uuidTryParse(path.evaluate("id", issue))).setFileName(path.evaluate("fileName", issue)).setLineStart(path.evaluate("lineStart", issue)).setLineEnd(path.evaluate("lineEnd", issue)).setColumnStart(path.evaluate("columnStart", issue)).setColumnEnd(path.evaluate("columnEnd", issue)).setLineRanges(this.readLineRanges(path, (NodeList)path.evaluate(LINE_RANGES_PATH, issue, XPathConstants.NODESET))).setCategory(path.evaluate("category", issue)).setType(path.evaluate("type", issue)).setSeverity(Severity.valueOf(path.evaluate("severity", issue), Severity.WARNING_NORMAL)).setMessage(path.evaluate("message", issue)).setDescription(path.evaluate("description", issue)).setPackageName(path.evaluate("packageName", issue)).setModuleName(path.evaluate("moduleName", issue)).setOrigin(path.evaluate("origin", issue)).setReference(path.evaluate("reference", issue)).setFingerprint(path.evaluate("fingerprint", issue)).setAdditionalProperties((Serializable)((Object)path.evaluate("additionalProperties", issue)));
                report.add(issueBuilder.build());
            }
            return report;
        }
        catch (XPathExpressionException e) {
            throw new ParsingException(e);
        }
    }

    private LineRangeList readLineRanges(XPath path, NodeList lineRanges) throws XPathExpressionException {
        LineRangeList ranges = new LineRangeList();
        for (Element lineRangeNode : XmlElementUtil.nodeListToList(lineRanges)) {
            if (lineRangeNode == null) continue;
            Element startNode = (Element)path.evaluate("start", lineRangeNode, XPathConstants.NODE);
            Element endNode = (Element)path.evaluate("end", lineRangeNode, XPathConstants.NODE);
            if (startNode == null || startNode.getFirstChild() == null || endNode == null || endNode.getFirstChild() == null) continue;
            String startValue = startNode.getFirstChild().getNodeValue().trim();
            String endValue = endNode.getFirstChild().getNodeValue().trim();
            try {
                int start = Integer.parseInt(startValue);
                int end = Integer.parseInt(endValue);
                ranges.add(new LineRange(start, end));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return ranges;
    }

    private UUID uuidTryParse(String uuidString) {
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException ex) {
            return UUID.randomUUID();
        }
    }
}

