/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.ccm;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.ccm.Ccm;
import edu.hm.hafner.analysis.parser.ccm.Metric;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class CcmParser
extends IssueParser {
    private static final long serialVersionUID = -5172155190810975806L;

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException {
        Ccm report = this.parseCCMXmlFile(readerFactory);
        return this.convert(report);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Ccm parseCCMXmlFile(ReaderFactory ccmXmlFile) {
        SecureDigester digester = new SecureDigester(CcmParser.class);
        String rootXPath = "ccm";
        digester.addObjectCreate(rootXPath, Ccm.class);
        digester.addSetProperties(rootXPath);
        String fileMetric = "ccm/metric";
        digester.addObjectCreate(fileMetric, Metric.class);
        digester.addSetProperties(fileMetric);
        digester.addBeanPropertySetter("ccm/metric/complexity");
        digester.addBeanPropertySetter("ccm/metric/unit");
        digester.addBeanPropertySetter("ccm/metric/classification");
        digester.addBeanPropertySetter("ccm/metric/file");
        digester.addBeanPropertySetter("ccm/metric/startLineNumber");
        digester.addBeanPropertySetter("ccm/metric/endLineNumber");
        digester.addSetNext(fileMetric, "addMetric", Metric.class.getName());
        try (Reader reader = ccmXmlFile.create();){
            Ccm report = (Ccm)digester.parse(reader);
            if (report == null) {
                throw new ParsingException("Input stream is not a CCM file.", new Object[0]);
            }
            Ccm ccm = report;
            return ccm;
        }
        catch (IOException | SAXException exception) {
            throw new ParsingException(exception);
        }
    }

    private Report convert(Ccm collection) {
        Report report = new Report();
        for (Metric metric : collection.getMetrics()) {
            Severity priority = this.calculateMetricPriority(metric);
            String complexity = String.format("%s has a complexity of %d", metric.getUnit(), metric.getComplexity());
            IssueBuilder builder = new IssueBuilder();
            builder.setSeverity(priority).setMessage(complexity).setCategory(metric.getClassification()).setLineStart(metric.getStartLineNumber()).setLineEnd(metric.getEndLineNumber()).setFileName(metric.getFile());
            report.add(builder.build());
        }
        return report;
    }

    private Severity calculateMetricPriority(Metric metric) {
        if (this.isMetricHighPriority(metric)) {
            return Severity.WARNING_HIGH;
        }
        if (this.isMetricModeratePriority(metric)) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }

    private boolean isMetricHighPriority(Metric metric) {
        String metricClassification = metric.getClassification();
        if (StringUtils.contains((CharSequence)metricClassification, (CharSequence)"high")) {
            return true;
        }
        return "C".equals(metricClassification) || "D".equals(metricClassification) || "E".equals(metricClassification) || "F".equals(metricClassification);
    }

    private boolean isMetricModeratePriority(Metric metric) {
        String metricClassification = metric.getClassification();
        if (StringUtils.contains((CharSequence)metricClassification, (CharSequence)"moderate")) {
            return true;
        }
        return "B".equals(metricClassification);
    }
}

