/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.checkstyle;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.analysis.parser.checkstyle.CheckStyle;
import edu.hm.hafner.analysis.parser.checkstyle.Error;
import edu.hm.hafner.analysis.parser.checkstyle.File;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class CheckStyleParser
extends IssueParser {
    private static final long serialVersionUID = -3187275729854832128L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException {
        SecureDigester digester = new SecureDigester(CheckStyleParser.class);
        String rootXPath = "checkstyle";
        digester.addObjectCreate(rootXPath, CheckStyle.class);
        digester.addSetProperties(rootXPath);
        String fileXPath = "checkstyle/file";
        digester.addObjectCreate(fileXPath, File.class);
        digester.addSetProperties(fileXPath);
        digester.addSetNext(fileXPath, "addFile", File.class.getName());
        String bugXPath = "checkstyle/file/error";
        digester.addObjectCreate(bugXPath, Error.class);
        digester.addSetProperties(bugXPath);
        digester.addSetNext(bugXPath, "addError", Error.class.getName());
        try (Reader reader = readerFactory.create();){
            CheckStyle checkStyle = (CheckStyle)digester.parse(reader);
            if (checkStyle == null) {
                throw new ParsingException("Input stream is not a Checkstyle file.", new Object[0]);
            }
            Report report = this.convert(checkStyle);
            return report;
        }
        catch (IOException | SAXException exception) {
            throw new ParsingException(exception);
        }
    }

    private Report convert(CheckStyle collection) {
        Report report = new Report();
        for (File file : collection.getFiles()) {
            if (!this.isValidWarning(file)) continue;
            for (Error error : file.getErrors()) {
                IssueBuilder builder = new IssueBuilder();
                builder.guessSeverity(error.getSeverity());
                String source = error.getSource();
                builder.setType(this.getType(source));
                builder.setCategory(this.getCategory(source));
                builder.setMessage(error.getMessage());
                builder.setLineStart(error.getLine());
                builder.setFileName(file.getName());
                builder.setColumnStart(error.getColumn());
                report.add(builder.build());
            }
        }
        return report;
    }

    private String getCategory(@Nullable String source) {
        return StringUtils.capitalize((String)this.getType(StringUtils.substringBeforeLast((String)source, (String)".")));
    }

    private String getType(@Nullable String source) {
        return StringUtils.substringAfterLast((String)source, (String)".");
    }

    private boolean isValidWarning(File file) {
        return !StringUtils.endsWith((CharSequence)file.getName(), (CharSequence)"package.html");
    }
}

