/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.dry;

import edu.hm.hafner.analysis.Issue;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class DuplicationGroup
implements Serializable {
    private static final long serialVersionUID = -5005784523279541971L;
    private final List<Issue> occurrences = new ArrayList<Issue>();
    private String codeFragment = "";

    public DuplicationGroup(@Nullable String codeFragment) {
        this.setCodeFragment(codeFragment);
    }

    public DuplicationGroup() {
        this("");
    }

    public void setCodeFragment(@Nullable String codeFragment) {
        if (StringUtils.isBlank((CharSequence)this.codeFragment)) {
            this.codeFragment = StringUtils.defaultString((String)codeFragment);
        }
    }

    public void add(Issue issue) {
        this.occurrences.add(issue);
    }

    public String getCodeFragment() {
        return this.codeFragment;
    }

    public List<Issue> getDuplications() {
        return new ArrayList<Issue>(this.occurrences);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DuplicationGroup that = (DuplicationGroup)o;
        return this.codeFragment.equals(that.codeFragment);
    }

    public int hashCode() {
        return this.codeFragment.hashCode();
    }
}

