/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.dry.cpd;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.dry.AbstractDryParser;
import edu.hm.hafner.analysis.parser.dry.DuplicationGroup;
import edu.hm.hafner.analysis.parser.dry.cpd.Duplication;
import edu.hm.hafner.analysis.parser.dry.cpd.SourceFile;
import java.util.List;
import org.apache.commons.digester3.Digester;

public class CpdParser
extends AbstractDryParser<Duplication> {
    private static final long serialVersionUID = 6507147028628714706L;

    public CpdParser(int highThreshold, int normalThreshold) {
        super(highThreshold, normalThreshold);
    }

    public CpdParser() {
        super(50, 25);
    }

    @Override
    protected void configureParser(Digester digester) {
        String duplicationXPath = "*/pmd-cpd/duplication";
        digester.addObjectCreate(duplicationXPath, Duplication.class);
        digester.addSetProperties(duplicationXPath);
        digester.addCallMethod(duplicationXPath + "/codefragment", "setCodeFragment", 0);
        digester.addSetNext(duplicationXPath, "add");
        String fileXPath = duplicationXPath + "/file";
        digester.addObjectCreate(fileXPath, SourceFile.class);
        digester.addSetProperties(fileXPath);
        digester.addSetNext(fileXPath, "addFile", SourceFile.class.getName());
    }

    @Override
    protected Report convertDuplicationsToIssues(List<Duplication> duplications, IssueBuilder issueBuilder) {
        Report report = new Report();
        for (Duplication duplication : duplications) {
            DuplicationGroup group = new DuplicationGroup(duplication.getCodeFragment());
            for (SourceFile file : duplication.getFiles()) {
                IssueBuilder builder = issueBuilder.setSeverity(this.getPriority(duplication.getLines())).setLineStart(file.getLine()).setLineEnd(file.getLine() + duplication.getLines() - 1).setFileName(file.getPath()).setAdditionalProperties(group);
                Issue issue = builder.build();
                group.add(issue);
                report.add(issue);
            }
        }
        return report;
    }
}

