/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.fxcop;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.fxcop.FxCopRule;
import edu.hm.hafner.analysis.parser.fxcop.FxCopRuleSet;
import edu.hm.hafner.util.XmlElementUtil;
import java.util.Optional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FxCopParser
extends IssueParser {
    private static final long serialVersionUID = -7208558002331355408L;

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException, ParsingCanceledException {
        return new XmlParser().parse(readerFactory);
    }

    private static class XmlParser {
        private final Report warnings = new Report();
        private final FxCopRuleSet ruleSet = new FxCopRuleSet();

        private XmlParser() {
        }

        public Report parse(ReaderFactory readerFactory) throws ParsingException, ParsingCanceledException {
            Document doc = readerFactory.readDocument();
            NodeList mainNode = doc.getElementsByTagName("FxCopReport");
            Element rootElement = (Element)mainNode.item(0);
            this.parseRules(rootElement);
            this.parseNamespaces(rootElement);
            this.parseTargets(rootElement);
            return this.warnings;
        }

        private void parseRules(Element rootElement) {
            Optional<Element> rulesElement = XmlElementUtil.getFirstChildElementByName(rootElement, "Rules");
            if (rulesElement.isPresent()) {
                for (Element rule : XmlElementUtil.getChildElementsByName(rulesElement.get(), "Rule")) {
                    this.ruleSet.addRule(rule);
                }
            }
        }

        private void parseTargets(Element rootElement) {
            Optional<Element> targetsElement = XmlElementUtil.getFirstChildElementByName(rootElement, "Targets");
            if (targetsElement.isPresent()) {
                for (Element target : XmlElementUtil.getChildElementsByName(targetsElement.get(), "Target")) {
                    String name = this.getString(target, "Name");
                    this.parseMessages(target, name);
                    this.parseModules(target, name);
                    this.parseResources(target, name);
                }
            }
        }

        private void parseResources(Element target, String parentName) {
            Optional<Element> resources = XmlElementUtil.getFirstChildElementByName(target, "Resources");
            if (resources.isPresent()) {
                for (Element resource : XmlElementUtil.getChildElementsByName(resources.get(), "Resource")) {
                    String name = this.getString(resource, "Name");
                    this.parseMessages(resource, name);
                }
            }
        }

        private void parseModules(Element target, String parentName) {
            Optional<Element> modulesElement = XmlElementUtil.getFirstChildElementByName(target, "Modules");
            if (modulesElement.isPresent()) {
                for (Element module : XmlElementUtil.getChildElementsByName(modulesElement.get(), "Module")) {
                    String name = this.getString(module, "Name");
                    this.parseMessages(module, name);
                    this.parseNamespaces(module);
                }
            }
        }

        private void parseNamespaces(Element rootElement) {
            Optional<Element> namespacesElement = XmlElementUtil.getFirstChildElementByName(rootElement, "Namespaces");
            if (namespacesElement.isPresent()) {
                for (Element namespace : XmlElementUtil.getChildElementsByName(namespacesElement.get(), "Namespace")) {
                    String name = this.getString(namespace, "Name");
                    this.parseMessages(namespace, name);
                    this.parseTypes(namespace, name);
                }
            }
        }

        private void parseTypes(Element typesElement, String parentName) {
            Optional<Element> types = XmlElementUtil.getFirstChildElementByName(typesElement, "Types");
            if (types.isPresent()) {
                for (Element type : XmlElementUtil.getChildElementsByName(types.get(), "Type")) {
                    String name = parentName + "." + this.getString(type, "Name");
                    this.parseMessages(type, name);
                    this.parseMembers(type, name);
                }
            }
        }

        private void parseMembers(Element members, String parentName) {
            Optional<Element> membersElement = XmlElementUtil.getFirstChildElementByName(members, "Members");
            if (membersElement.isPresent()) {
                for (Element member : XmlElementUtil.getChildElementsByName(membersElement.get(), "Member")) {
                    this.parseMember(member, parentName);
                }
            }
        }

        private void parseAccessors(Element accessorsElement, String parentName) {
            Optional<Element> accessors = XmlElementUtil.getFirstChildElementByName(accessorsElement, "Accessors");
            if (accessors.isPresent()) {
                for (Element member : XmlElementUtil.getChildElementsByName(accessors.get(), "Accessor")) {
                    this.parseMember(member, parentName);
                }
            }
        }

        private void parseMember(Element member, String parentName) {
            this.parseMessages(member, parentName);
            this.parseAccessors(member, parentName);
        }

        private void parseMessages(Element messages, String parentName) {
            Optional<Element> messagesElement = XmlElementUtil.getFirstChildElementByName(messages, "Messages");
            if (messagesElement.isPresent()) {
                for (Element message : XmlElementUtil.getChildElementsByName(messagesElement.get(), "Message")) {
                    for (Element issue : XmlElementUtil.getChildElementsByName(message, "Issue")) {
                        this.parseIssue(issue, message, parentName);
                    }
                }
            }
        }

        private void parseIssue(Element issue, Element parent, String parentName) {
            String typeName = this.getString(parent, "TypeName");
            String category = this.getString(parent, "Category");
            String checkId = this.getString(parent, "CheckId");
            String issueLevel = this.getString(issue, "Level");
            StringBuilder msgBuilder = new StringBuilder();
            FxCopRule rule = this.ruleSet.getRule(category, checkId);
            if (rule == null) {
                msgBuilder.append(typeName);
            } else {
                msgBuilder.append("<a href=\"");
                msgBuilder.append(rule.getUrl());
                msgBuilder.append("\">");
                msgBuilder.append(typeName);
                msgBuilder.append("</a>");
            }
            msgBuilder.append(" - ");
            msgBuilder.append(issue.getTextContent());
            String filePath = this.getString(issue, "Path");
            String fileName = this.getString(issue, "File");
            String fileLine = this.getString(issue, "Line");
            IssueBuilder builder = new IssueBuilder().setFileName(filePath + "/" + fileName).setLineStart(fileLine).setCategory(category).setMessage(msgBuilder.toString()).guessSeverity(issueLevel);
            if (rule != null) {
                builder.setDescription(rule.getDescription());
            }
            this.warnings.add(builder.build());
        }

        private String getString(Element element, String name) {
            if (element.hasAttribute(name)) {
                return element.getAttribute(name);
            }
            return "";
        }
    }
}

