/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.pmd;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.pmd.File;
import edu.hm.hafner.analysis.parser.pmd.Pmd;
import edu.hm.hafner.analysis.parser.pmd.PmdError;
import edu.hm.hafner.analysis.parser.pmd.Violation;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class PmdParser
extends IssueParser {
    private static final long serialVersionUID = 6507147028628714706L;
    private static final int PMD_PRIORITY_MAPPED_TO_HIGH_PRIORITY = 3;
    private static final int PMD_PRIORITY_MAPPED_TO_LOW_PRIORITY = 4;

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException {
        Report issues = this.parseIssues(readerFactory);
        issues.addAll(this.parseErrors(readerFactory));
        return issues;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Report parseIssues(ReaderFactory readerFactory) {
        SecureDigester digester = new SecureDigester(PmdParser.class);
        String rootXPath = "pmd";
        digester.addObjectCreate(rootXPath, Pmd.class);
        digester.addSetProperties(rootXPath);
        String fileXPath = "pmd/file";
        digester.addObjectCreate(fileXPath, File.class);
        digester.addSetProperties(fileXPath);
        digester.addSetNext(fileXPath, "addFile", File.class.getName());
        String bugXPath = "pmd/file/violation";
        digester.addObjectCreate(bugXPath, Violation.class);
        digester.addSetProperties(bugXPath);
        digester.addCallMethod(bugXPath, "setMessage", 0);
        digester.addSetNext(bugXPath, "addViolation", Violation.class.getName());
        try (Reader reader = readerFactory.create();){
            Pmd pmd = (Pmd)digester.parse(reader);
            if (pmd == null) {
                throw new ParsingException("Input stream is not a PMD file.", new Object[0]);
            }
            Report report = this.convertIssues(pmd);
            return report;
        }
        catch (IOException | SAXException exception) {
            throw new ParsingException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Report parseErrors(ReaderFactory readerFactory) {
        SecureDigester digester = new SecureDigester(PmdParser.class);
        String rootXPath = "pmd";
        digester.addObjectCreate(rootXPath, Pmd.class);
        digester.addSetProperties(rootXPath);
        String errorXPath = "pmd/error";
        digester.addObjectCreate(errorXPath, PmdError.class);
        digester.addSetProperties(errorXPath);
        digester.addSetNext(errorXPath, "addError", PmdError.class.getName());
        digester.addCallMethod(errorXPath, "setDescription", 0);
        try (Reader reader = readerFactory.create();){
            Pmd pmd = (Pmd)digester.parse(reader);
            if (pmd == null) {
                throw new ParsingException("Input stream is not a PMD file.", new Object[0]);
            }
            Report report = this.convertErrors(pmd);
            return report;
        }
        catch (IOException | SAXException exception) {
            throw new ParsingException(exception);
        }
    }

    private Report convertIssues(Pmd pmdIssues) {
        Report report = new Report();
        for (File file : pmdIssues.getFiles()) {
            for (Violation warning : file.getViolations()) {
                IssueBuilder builder = new IssueBuilder().setSeverity(this.mapPriority(warning)).setMessage(this.createMessage(warning)).setCategory(warning.getRuleset()).setType(warning.getRule()).setLineStart(warning.getBeginline()).setLineEnd(warning.getEndline()).setPackageName(warning.getPackage()).setFileName(file.getName()).setColumnStart(warning.getBegincolumn()).setColumnEnd(warning.getEndcolumn());
                report.add(builder.build());
            }
        }
        return report;
    }

    private Report convertErrors(Pmd pmdIssues) {
        Report report = new Report();
        for (PmdError error : pmdIssues.getErrors()) {
            IssueBuilder builder = new IssueBuilder().setSeverity(Severity.ERROR).setMessage(error.getMsg()).setDescription(error.getDescription()).setFileName(error.getFilename());
            report.add(builder.build());
        }
        return report;
    }

    private Severity mapPriority(Violation warning) {
        if (warning.getPriority() < 3) {
            return Severity.WARNING_HIGH;
        }
        if (warning.getPriority() > 4) {
            return Severity.WARNING_LOW;
        }
        return Severity.WARNING_NORMAL;
    }

    private String createMessage(Violation warning) {
        String original = warning.getMessage();
        if (original == null) {
            return "";
        }
        if (StringUtils.endsWith((CharSequence)original, (CharSequence)".")) {
            return original;
        }
        return original + ".";
    }
}

