/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.pvsstudio;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.pvsstudio.AnalyzerType;
import edu.hm.hafner.analysis.parser.pvsstudio.PlogMessage;
import java.util.List;

public class PVSStudioParser
extends IssueParser {
    private static final long serialVersionUID = -7777775729854832128L;

    private static Severity getSeverity(String level) {
        if ("1".equals(level)) {
            return Severity.WARNING_HIGH;
        }
        if ("2".equals(level)) {
            return Severity.WARNING_NORMAL;
        }
        if ("3".equals(level)) {
            return Severity.WARNING_LOW;
        }
        return Severity.ERROR;
    }

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException, ParsingCanceledException {
        List<PlogMessage> plogMessages = PlogMessage.getMessagesFromReport(readerFactory);
        Report report = new Report();
        for (PlogMessage plogMessage : plogMessages) {
            IssueBuilder builder = new IssueBuilder();
            builder.setFileName(plogMessage.getFilePath());
            builder.setSeverity(PVSStudioParser.getSeverity(plogMessage.getLevel()));
            builder.setMessage(plogMessage.toString());
            builder.setCategory(plogMessage.getType());
            builder.setType(AnalyzerType.fromErrorCode(plogMessage.getType()).getMessage());
            builder.setLineStart(plogMessage.getLine());
            report.add(builder.build());
        }
        return report;
    }
}

