/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.violations;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LineRange;
import edu.hm.hafner.analysis.LineRangeList;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.violations.AbstractViolationAdapter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.CPPCheckParser;

public class CppCheckAdapter
extends AbstractViolationAdapter {
    private static final long serialVersionUID = 2244442395053328008L;

    CPPCheckParser createParser() {
        return new CPPCheckParser();
    }

    @Override
    Report convertToReport(List<Violation> violations) {
        Map<String, List<Violation>> violationsPerGroup = new LinkedHashSet<Violation>(violations).stream().collect(Collectors.groupingBy(Violation::getGroup));
        Report report = new Report();
        for (List<Violation> group : violationsPerGroup.values()) {
            IssueBuilder issueBuilder = this.createIssueBuilder(group.get(0));
            LineRangeList lineRanges = new LineRangeList();
            for (int i = 1; i < group.size(); ++i) {
                Violation violation = group.get(i);
                lineRanges.add(new LineRange(violation.getStartLine()));
            }
            issueBuilder.setLineRanges(lineRanges);
            report.add(issueBuilder.build());
        }
        return report;
    }
}

