/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class LookaheadStream
implements AutoCloseable {
    private final Stream<String> stream;
    private final Iterator<String> lineIterator;
    private final String fileName;
    private boolean isLookaheadFilled = false;
    private String lookaheadLine = "";
    private int line = 0;

    public LookaheadStream(Stream<String> stream) {
        this(stream, "");
    }

    public LookaheadStream(Stream<String> stream, String fileName) {
        this.stream = stream;
        this.lineIterator = stream.iterator();
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void close() {
        this.stream.close();
    }

    public boolean hasNext() {
        return this.lineIterator.hasNext() || this.isLookaheadFilled;
    }

    public boolean hasNext(String regexp) {
        if (!this.isLookaheadFilled) {
            if (!this.hasNext()) {
                return false;
            }
            this.fillLookahead();
        }
        return Pattern.compile(regexp).matcher(this.lookaheadLine).find();
    }

    public String peekNext() {
        if (!this.isLookaheadFilled) {
            this.fillLookahead();
        }
        return this.lookaheadLine;
    }

    private void fillLookahead() {
        this.lookaheadLine = this.lineIterator.next();
        this.isLookaheadFilled = true;
    }

    public String next() {
        ++this.line;
        if (this.isLookaheadFilled) {
            this.isLookaheadFilled = false;
            return this.lookaheadLine;
        }
        return this.lineIterator.next();
    }

    public int getLine() {
        return this.line;
    }

    public String toString() {
        return String.format("[%d] -> '%s'", this.line, this.lookaheadLine);
    }
}

