/*
 * The MIT License
 *
 * Copyright (c) 2010 Bruno P. Kinoshita <http://www.kinoshita.eti.br>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package edu.hm.hafner.analysis.parser.ccm;

import edu.umd.cs.findbugs.annotations.Nullable;

/**
 * <p>Entity representing the Metric from CCM.exe output.</p>
 *
 * <p>It has the {@link #complexity}, {@link #unit}, {@link #classification}
 * and {@link #file} fields.</p>
 *
 * @author Bruno P. Kinoshita - http://www.kinoshita.eti.br
 * @since 1.0
 */
@SuppressWarnings("all")
public class Metric {
    /**
     * Total CC of the method.
     */
    private int complexity;

    /**
     * String containing Class_Name::Method_Name
     */
    @Nullable
    private String unit;

    /**
     * CCM outputs a String with a classification such as "complex, high risk", "untestable, very high risk", etc. As
     * there is no documentation on which values are used to determine a method's CC classification CCM Plugin only
     * outputs this value. But does not use the information as a constraint in any place.
     */
    @Nullable
    private String classification;

    /**
     * The file name (e.g.:\ascx\request\open\form.ascx.cs).
     */
    @Nullable
    private String file;

    /**
     * The start line number of the measurement
     */
    private int startLineNumber;

    /**
     * The end line number of the measurement
     */
    private int endLineNumber;

    public int getComplexity() {
        return complexity;
    }

    public void setComplexity(int complexity) {
        this.complexity = complexity;
    }

    @Nullable
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Nullable
    public String getClassification() {
        return classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    @Nullable
    public String getFile() {
        return file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public int getStartLineNumber() {
        return startLineNumber;
    }

    public void setStartLineNumber(int startLineNumber) {
        this.startLineNumber = startLineNumber;
    }

    public int getEndLineNumber() {
        return endLineNumber;
    }

    public void setEndLineNumber(int endLineNumber) {
        this.endLineNumber = endLineNumber;
    }

}
