/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.Client;
import eu.chargetime.ocpp.ClientEvents;
import eu.chargetime.ocpp.Communicator;
import eu.chargetime.ocpp.FeatureRepository;
import eu.chargetime.ocpp.IClientAPI;
import eu.chargetime.ocpp.IFeatureRepository;
import eu.chargetime.ocpp.IPromiseRepository;
import eu.chargetime.ocpp.ISession;
import eu.chargetime.ocpp.JSONCommunicator;
import eu.chargetime.ocpp.JSONConfiguration;
import eu.chargetime.ocpp.OccurenceConstraintException;
import eu.chargetime.ocpp.PromiseRepository;
import eu.chargetime.ocpp.Radio;
import eu.chargetime.ocpp.SessionFactory;
import eu.chargetime.ocpp.UnsupportedFeatureException;
import eu.chargetime.ocpp.WebSocketTransmitter;
import eu.chargetime.ocpp.feature.profile.ClientCoreProfile;
import eu.chargetime.ocpp.feature.profile.Profile;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.wss.BaseWssSocketBuilder;
import eu.chargetime.ocpp.wss.WssSocketBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.SSLContext;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.protocols.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONClient
implements IClientAPI {
    private static final Logger logger = LoggerFactory.getLogger(JSONClient.class);
    public final Draft draftOcppOnly;
    private final WebSocketTransmitter transmitter;
    private final FeatureRepository featureRepository;
    private final Client client;
    private final String identity;

    public JSONClient(ClientCoreProfile coreProfile) {
        this(coreProfile, null);
    }

    public JSONClient(ClientCoreProfile coreProfile, String identity, JSONConfiguration configuration) {
        this.identity = identity;
        this.draftOcppOnly = new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("ocpp1.6")));
        this.transmitter = new WebSocketTransmitter(configuration, this.draftOcppOnly);
        JSONCommunicator communicator = new JSONCommunicator((Radio)this.transmitter);
        this.featureRepository = new FeatureRepository();
        ISession session = new SessionFactory((IFeatureRepository)this.featureRepository).createSession((Communicator)communicator);
        this.client = new Client(session, (IFeatureRepository)this.featureRepository, (IPromiseRepository)new PromiseRepository());
        this.featureRepository.addFeatureProfile((Profile)coreProfile);
    }

    public JSONClient(ClientCoreProfile coreProfile, String identity) {
        this(coreProfile, identity, JSONConfiguration.get());
    }

    public JSONClient(ClientCoreProfile coreProfile, String identity, WssSocketBuilder wssSocketBuilder, JSONConfiguration configuration) {
        this(coreProfile, identity, configuration);
        this.enableWSS(wssSocketBuilder);
    }

    public JSONClient(ClientCoreProfile coreProfile, String identity, WssSocketBuilder wssSocketBuilder) {
        this(coreProfile, identity, wssSocketBuilder, JSONConfiguration.get());
    }

    public void enableWSS(SSLContext sslContext) throws IOException {
        BaseWssSocketBuilder wssSocketBuilder = BaseWssSocketBuilder.builder().sslSocketFactory(sslContext.getSocketFactory());
        this.enableWSS((WssSocketBuilder)wssSocketBuilder);
    }

    public JSONClient enableWSS(WssSocketBuilder wssSocketBuilder) {
        wssSocketBuilder.verify();
        this.transmitter.enableWSS(wssSocketBuilder);
        return this;
    }

    @Override
    public void addFeatureProfile(Profile profile) {
        this.featureRepository.addFeatureProfile(profile);
    }

    @Override
    public void connect(String url, ClientEvents clientEvents) {
        logger.debug("Feature repository: {}", (Object)this.featureRepository);
        String identityUrl = this.identity != null ? String.format("%s/%s", url, this.identity) : url;
        this.client.connect(identityUrl, clientEvents);
    }

    @Override
    public CompletionStage<Confirmation> send(Request request) throws OccurenceConstraintException, UnsupportedFeatureException {
        return this.client.send(request);
    }

    @Override
    public void disconnect() {
        this.client.disconnect();
    }

    @Override
    public boolean isClosed() {
        return this.transmitter.isClosed();
    }
}

