/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.FeatureRepository;
import eu.chargetime.ocpp.IFeatureRepository;
import eu.chargetime.ocpp.IPromiseRepository;
import eu.chargetime.ocpp.IServerAPI;
import eu.chargetime.ocpp.ISessionFactory;
import eu.chargetime.ocpp.JSONConfiguration;
import eu.chargetime.ocpp.Listener;
import eu.chargetime.ocpp.NotConnectedException;
import eu.chargetime.ocpp.OccurenceConstraintException;
import eu.chargetime.ocpp.PromiseRepository;
import eu.chargetime.ocpp.Server;
import eu.chargetime.ocpp.ServerEvents;
import eu.chargetime.ocpp.SessionFactory;
import eu.chargetime.ocpp.UnsupportedFeatureException;
import eu.chargetime.ocpp.WebSocketListener;
import eu.chargetime.ocpp.feature.profile.Profile;
import eu.chargetime.ocpp.feature.profile.ServerCoreProfile;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.wss.BaseWssFactoryBuilder;
import eu.chargetime.ocpp.wss.WssFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.SSLContext;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.protocols.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONServer
implements IServerAPI {
    private static final Logger logger = LoggerFactory.getLogger(JSONServer.class);
    public final Draft draftOcppOnly;
    private final WebSocketListener listener;
    private final Server server;
    private final FeatureRepository featureRepository = new FeatureRepository();
    private JSONConfiguration jsonConfiguration;

    public JSONServer(ServerCoreProfile coreProfile, JSONConfiguration configuration) {
        SessionFactory sessionFactory = new SessionFactory((IFeatureRepository)this.featureRepository);
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(new Protocol("ocpp1.6"));
        protocols.add(new Protocol(""));
        this.draftOcppOnly = new Draft_6455(Collections.emptyList(), protocols);
        this.listener = new WebSocketListener((ISessionFactory)sessionFactory, configuration, new Draft[]{this.draftOcppOnly});
        this.server = new Server((Listener)this.listener, (IFeatureRepository)this.featureRepository, (IPromiseRepository)new PromiseRepository());
        this.featureRepository.addFeatureProfile((Profile)coreProfile);
    }

    public JSONServer(ServerCoreProfile coreProfile) {
        this(coreProfile, JSONConfiguration.get());
    }

    public JSONServer(ServerCoreProfile coreProfile, WssFactoryBuilder wssFactoryBuilder, JSONConfiguration configuration) {
        this(coreProfile, configuration);
        this.enableWSS(wssFactoryBuilder);
    }

    public JSONServer(ServerCoreProfile coreProfile, WssFactoryBuilder wssFactoryBuilder) {
        this(coreProfile, wssFactoryBuilder, JSONConfiguration.get());
    }

    public void enableWSS(SSLContext sslContext) throws IOException {
        BaseWssFactoryBuilder builder = BaseWssFactoryBuilder.builder().sslContext(sslContext);
        this.enableWSS((WssFactoryBuilder)builder);
    }

    public JSONServer enableWSS(WssFactoryBuilder wssFactoryBuilder) {
        wssFactoryBuilder.verify();
        this.listener.enableWSS(wssFactoryBuilder);
        return this;
    }

    @Override
    public void addFeatureProfile(Profile profile) {
        this.featureRepository.addFeatureProfile(profile);
    }

    @Override
    public void closeSession(UUID session) {
        this.server.closeSession(session);
    }

    @Override
    public void open(String host, int port, ServerEvents serverEvents) {
        logger.info("Feature repository: {}", (Object)this.featureRepository);
        this.server.open(host, port, serverEvents);
    }

    @Override
    public void close() {
        this.server.close();
    }

    @Override
    public boolean isClosed() {
        return this.listener.isClosed();
    }

    @Override
    public CompletionStage<Confirmation> send(UUID session, Request request) throws OccurenceConstraintException, UnsupportedFeatureException, NotConnectedException {
        return this.server.send(session, request);
    }
}

