/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import com.sun.net.httpserver.HttpServer;
import eu.chargetime.ocpp.Client;
import eu.chargetime.ocpp.ClientEvents;
import eu.chargetime.ocpp.Communicator;
import eu.chargetime.ocpp.FeatureRepository;
import eu.chargetime.ocpp.IClientAPI;
import eu.chargetime.ocpp.IFeatureRepository;
import eu.chargetime.ocpp.IPromiseRepository;
import eu.chargetime.ocpp.ISession;
import eu.chargetime.ocpp.OccurenceConstraintException;
import eu.chargetime.ocpp.PromiseRepository;
import eu.chargetime.ocpp.Radio;
import eu.chargetime.ocpp.SOAPCommunicator;
import eu.chargetime.ocpp.SessionFactory;
import eu.chargetime.ocpp.UnsupportedFeatureException;
import eu.chargetime.ocpp.WSHttpHandler;
import eu.chargetime.ocpp.WebServiceTransmitter;
import eu.chargetime.ocpp.feature.profile.ClientCoreProfile;
import eu.chargetime.ocpp.feature.profile.Profile;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.SOAPHostInfo;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOAPClient
implements IClientAPI {
    private static final Logger logger = LoggerFactory.getLogger(SOAPClient.class);
    private static final String WSDL_CHARGE_POINT = "eu/chargetime/ocpp/OCPP_ChargePointService_1.6.wsdl";
    private Client client;
    private SOAPCommunicator communicator;
    private WebServiceTransmitter transmitter;
    private URL callback;
    private HttpServer server;
    private ExecutorService threadPool;
    private FeatureRepository featureRepository;

    public SOAPClient(String chargeBoxIdentity, URL callback, ClientCoreProfile coreProfile) {
        SOAPHostInfo hostInfo = new SOAPHostInfo.Builder().isClient(true).chargeBoxIdentity(chargeBoxIdentity).fromUrl(callback.toString()).namespace("urn://Ocpp/Cp/2015/10/").build();
        this.callback = callback;
        this.transmitter = new WebServiceTransmitter();
        this.communicator = new SOAPCommunicator(hostInfo, (Radio)this.transmitter);
        this.featureRepository = new FeatureRepository();
        ISession session = new SessionFactory((IFeatureRepository)this.featureRepository).createSession((Communicator)this.communicator);
        this.client = new Client(session, (IFeatureRepository)this.featureRepository, (IPromiseRepository)new PromiseRepository());
        this.featureRepository.addFeatureProfile((Profile)coreProfile);
    }

    @Override
    public void addFeatureProfile(Profile profile) {
        this.featureRepository.addFeatureProfile(profile);
    }

    @Override
    public void connect(String uri, ClientEvents events) {
        this.communicator.setToUrl(uri);
        this.client.connect(uri, events);
        this.openWS();
    }

    @Override
    public CompletionStage<Confirmation> send(Request request) throws OccurenceConstraintException, UnsupportedFeatureException {
        return this.client.send(request);
    }

    @Override
    public void disconnect() {
        this.client.disconnect();
        if (this.server != null) {
            this.server.stop(1);
            this.threadPool.shutdownNow();
        }
    }

    @Override
    public boolean isClosed() {
        return this.transmitter.isClosed();
    }

    private int getPort() {
        return this.callback.getPort() == -1 ? 8000 : this.callback.getPort();
    }

    private void openWS() {
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.callback.getHost(), this.getPort()), 0);
            this.server.createContext("/", new WSHttpHandler(WSDL_CHARGE_POINT, message -> {
                SOAPMessage soapMessage = null;
                try {
                    soapMessage = this.transmitter.relay(message.getMessage()).get();
                }
                catch (InterruptedException e) {
                    logger.warn("openWS() transmitter.relay failed", (Throwable)e);
                }
                catch (ExecutionException e) {
                    logger.warn("openWS() transmitter.relay failed", (Throwable)e);
                }
                return soapMessage;
            }));
            this.threadPool = Executors.newCachedThreadPool();
            this.server.setExecutor(this.threadPool);
            this.server.start();
        }
        catch (IOException e) {
            logger.warn("openWS() failed", (Throwable)e);
        }
    }
}

