/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.Communicator;
import eu.chargetime.ocpp.Radio;
import eu.chargetime.ocpp.model.CallErrorMessage;
import eu.chargetime.ocpp.model.CallMessage;
import eu.chargetime.ocpp.model.CallResultMessage;
import eu.chargetime.ocpp.model.Message;
import eu.chargetime.ocpp.model.SOAPHostInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPCommunicator
extends Communicator {
    private static final Logger logger = LoggerFactory.getLogger(SOAPCommunicator.class);
    private static final String HEADER_ACTION = "Action";
    private static final String HEADER_MESSAGEID = "MessageID";
    private static final String HEADER_RELATESTO = "RelatesTo";
    private static final String HEADER_FROM = "From";
    private static final String HEADER_REPLYTO = "ReplyTo";
    private static final String HEADER_REPLYTO_ADDRESS = "Address";
    private static final String HEADER_TO = "To";
    private static final String HEADER_CHARGEBOXIDENTITY = "chargeBoxIdentity";
    private final SOAPHostInfo hostInfo;
    private String toUrl;

    public SOAPCommunicator(SOAPHostInfo hostInfo, Radio radio) {
        super(radio);
        this.hostInfo = hostInfo;
    }

    public <T> T unpackPayload(Object payload, Class<T> type) {
        Object output = null;
        try {
            Document input = (Document)payload;
            this.setNamespace(input, "urn://Ocpp/Cs/2015/10/");
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{type}).createUnmarshaller();
            JAXBElement jaxbElement = unmarshaller.unmarshal((Node)input, type);
            output = jaxbElement.getValue();
        }
        catch (JAXBException e) {
            logger.warn("unpackPayload() failed", (Throwable)e);
        }
        return (T)output;
    }

    public Object packPayload(Object payload) {
        Document document = null;
        try {
            Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{payload.getClass()}).createMarshaller();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            document = factory.newDocumentBuilder().newDocument();
            marshaller.marshal(payload, (Node)document);
            this.setNamespace(document, this.hostInfo.getNamespace());
        }
        catch (JAXBException | ParserConfigurationException e) {
            logger.warn("packPayload() failed", e);
        }
        return document;
    }

    private void setNamespace(Document document, String namespace) {
        Element orgElement = document.getDocumentElement();
        Element newElement = document.createElementNS(namespace, orgElement.getNodeName());
        NodeList childNodes = orgElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            this.appendChildNS(document, newElement, childNodes.item(i), namespace);
        }
        document.replaceChild(newElement, orgElement);
    }

    private void appendChildNS(Document doc, Node destination, Node child, String namespace) {
        Node newChild;
        if (child.getNodeType() == 1) {
            newChild = doc.createElementNS(namespace, child.getNodeName());
            NodeList childNodes = child.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                this.appendChildNS(doc, newChild, childNodes.item(i), namespace);
            }
        } else {
            newChild = child;
        }
        destination.appendChild(newChild);
    }

    protected Object makeCallResult(String uniqueId, String action, Object payload) {
        return this.createMessage(uniqueId, String.format("%sResponse", action), (Document)payload, true);
    }

    protected Object makeCall(String uniqueId, String action, Object payload) {
        return this.createMessage(uniqueId, action, (Document)payload, false);
    }

    private QName blameSomeone(String errorCode) {
        QName result = SOAPConstants.SOAP_RECEIVER_FAULT;
        if ("SecurityError".equals(errorCode) || "IdentityMismatch".equals(errorCode) || "ProtocolError".equals(errorCode)) {
            return SOAPConstants.SOAP_SENDER_FAULT;
        }
        return result;
    }

    protected Object makeCallError(String uniqueId, String action, String errorCode, String errorDescription) {
        SOAPMessage message = null;
        try {
            MessageFactory messageFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
            message = messageFactory.createMessage();
            message.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
            this.createMessageHeader(uniqueId, String.format("%sResponse", action), true, message);
            SOAPFault soapFault = message.getSOAPBody().addFault();
            soapFault.setFaultCode(this.blameSomeone(errorCode));
            soapFault.setFaultString(errorDescription);
            soapFault.appendFaultSubcode(new QName(this.hostInfo.getNamespace(), errorCode));
        }
        catch (SOAPException e) {
            logger.warn("makeCallError() failed", (Throwable)e);
        }
        return message;
    }

    private Object createMessage(String uniqueId, String action, Document payload, boolean isResponse) {
        SOAPMessage message = null;
        try {
            MessageFactory messageFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
            message = messageFactory.createMessage();
            message.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
            this.createMessageHeader(uniqueId, action, isResponse, message);
            if (isResponse) {
                this.setNamespace(payload, this.hostInfo.isClient() ? "urn://Ocpp/Cp/2015/10/" : "urn://Ocpp/Cs/2015/10/");
            }
            message.getSOAPBody().addDocument(payload);
        }
        catch (Exception e) {
            logger.warn("createMessage() failed", (Throwable)e);
        }
        return message;
    }

    private void createMessageHeader(String uniqueId, String action, boolean isResponse, SOAPMessage message) throws SOAPException {
        SOAPFactory soapFactory = SOAPFactory.newInstance();
        SOAPHeader soapHeader = message.getSOAPHeader();
        String prefix = "wsa";
        String namespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
        SOAPHeaderElement chargeBoxIdentityHeader = soapHeader.addHeaderElement(soapFactory.createName(HEADER_CHARGEBOXIDENTITY, "cs", this.hostInfo.getNamespace()));
        chargeBoxIdentityHeader.setMustUnderstand(true);
        chargeBoxIdentityHeader.setValue(this.hostInfo.getChargeBoxIdentity());
        SOAPHeaderElement actionHeader = soapHeader.addHeaderElement(soapFactory.createName(HEADER_ACTION, prefix, namespace));
        actionHeader.setMustUnderstand(true);
        actionHeader.setValue(String.format("/%s", action));
        SOAPHeaderElement messageIDHeader = soapHeader.addHeaderElement(soapFactory.createName(HEADER_MESSAGEID, prefix, namespace));
        messageIDHeader.setMustUnderstand(true);
        messageIDHeader.setValue(uniqueId);
        if (isResponse) {
            SOAPHeaderElement relatesToHeader = soapHeader.addHeaderElement(soapFactory.createName(HEADER_RELATESTO, prefix, namespace));
            relatesToHeader.setValue(uniqueId);
        }
        SOAPHeaderElement fromHeader = soapHeader.addHeaderElement(soapFactory.createName(HEADER_FROM, prefix, namespace));
        fromHeader.setValue(this.hostInfo.getFromUrl());
        SOAPHeaderElement replyToHeader = soapHeader.addHeaderElement(soapFactory.createName(HEADER_REPLYTO, prefix, namespace));
        replyToHeader.setMustUnderstand(true);
        SOAPElement addressElement = replyToHeader.addChildElement(soapFactory.createName(HEADER_REPLYTO_ADDRESS, prefix, namespace));
        addressElement.setValue("http://www.w3.org/2005/08/addressing/anonymous");
        SOAPHeaderElement toHeader = soapHeader.addHeaderElement(soapFactory.createName(HEADER_TO, prefix, namespace));
        toHeader.setMustUnderstand(true);
        toHeader.setValue(this.toUrl);
    }

    protected Message parse(Object message) {
        Message output = null;
        SOAPParser soapParser = new SOAPParser((SOAPMessage)message);
        if (soapParser.isAddressedToMe()) {
            output = soapParser.parseMessage();
        }
        return output;
    }

    public String getToUrl() {
        return this.toUrl;
    }

    public void setToUrl(String toUrl) {
        this.toUrl = toUrl;
    }

    private class SOAPParser {
        private SOAPHeader soapHeader;
        private SOAPMessage soapMessage;

        public SOAPParser(SOAPMessage message) {
            try {
                this.soapMessage = message;
                this.soapHeader = message.getSOAPPart().getEnvelope().getHeader();
            }
            catch (SOAPException e) {
                logger.error("SOAPParser() failed", (Throwable)e);
            }
        }

        public Message parseMessage() {
            Object output = null;
            try {
                String relatesTo = this.getElementValue(SOAPCommunicator.HEADER_RELATESTO);
                String action = this.getElementValue(SOAPCommunicator.HEADER_ACTION);
                output = relatesTo != null && !relatesTo.isEmpty() && action != null && action.endsWith("Response") ? (this.soapMessage.getSOAPBody().hasFault() ? this.parseError() : this.parseResult()) : this.parseCall();
                if (action != null && !action.isEmpty()) {
                    output.setAction(action.substring(1));
                }
                if (!this.soapMessage.getSOAPBody().hasFault()) {
                    output.setPayload((Object)this.soapMessage.getSOAPBody().extractContentAsDocument());
                }
            }
            catch (SOAPException e) {
                logger.warn("parseMessage() failed", (Throwable)e);
            }
            return output;
        }

        public boolean isAddressedToMe() {
            String to = this.getElementValue(SOAPCommunicator.HEADER_TO);
            String cbIdentity = this.getElementValue(SOAPCommunicator.HEADER_CHARGEBOXIDENTITY);
            return SOAPCommunicator.this.hostInfo.getFromUrl().equals(to) && SOAPCommunicator.this.hostInfo.getChargeBoxIdentity().equals(cbIdentity);
        }

        private CallErrorMessage parseError() {
            CallErrorMessage message = new CallErrorMessage();
            String id = this.getElementValue(SOAPCommunicator.HEADER_RELATESTO);
            message.setId(id);
            try {
                SOAPFault fault = this.soapMessage.getSOAPBody().getFault();
                if (fault.getFaultSubcodes().hasNext()) {
                    message.setErrorCode(((QName)fault.getFaultSubcodes().next()).getLocalPart());
                }
                if (fault.getFaultReasonTexts().hasNext()) {
                    message.setErrorDescription(fault.getFaultReasonTexts().next().toString());
                }
            }
            catch (SOAPException e) {
                logger.error("Parse error", (Throwable)e);
            }
            return message;
        }

        private CallResultMessage parseResult() {
            CallResultMessage message = new CallResultMessage();
            String id = this.getElementValue(SOAPCommunicator.HEADER_RELATESTO);
            message.setId(id);
            return message;
        }

        private CallMessage parseCall() {
            CallMessage message = new CallMessage();
            String id = this.getElementValue(SOAPCommunicator.HEADER_MESSAGEID);
            message.setId(id);
            return message;
        }

        private String getElementValue(String tagName) {
            String value = null;
            NodeList elements = this.soapHeader.getElementsByTagNameNS("*", tagName);
            if (elements.getLength() > 0) {
                value = elements.item(0).getChildNodes().item(0).getNodeValue();
            }
            return value;
        }
    }
}

