/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.FeatureRepository;
import eu.chargetime.ocpp.IFeatureRepository;
import eu.chargetime.ocpp.IPromiseRepository;
import eu.chargetime.ocpp.IServerAPI;
import eu.chargetime.ocpp.ISessionFactory;
import eu.chargetime.ocpp.Listener;
import eu.chargetime.ocpp.NotConnectedException;
import eu.chargetime.ocpp.OccurenceConstraintException;
import eu.chargetime.ocpp.PromiseRepository;
import eu.chargetime.ocpp.Server;
import eu.chargetime.ocpp.ServerEvents;
import eu.chargetime.ocpp.SessionFactory;
import eu.chargetime.ocpp.UnsupportedFeatureException;
import eu.chargetime.ocpp.WebServiceListener;
import eu.chargetime.ocpp.feature.profile.Profile;
import eu.chargetime.ocpp.feature.profile.ServerCoreProfile;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.Request;
import java.util.UUID;
import java.util.concurrent.CompletionStage;

public class SOAPServer
implements IServerAPI {
    private final FeatureRepository featureRepository = new FeatureRepository();
    private final Server server;
    private final WebServiceListener listener;

    public SOAPServer(ServerCoreProfile coreProfile) {
        SessionFactory sessionFactory = new SessionFactory((IFeatureRepository)this.featureRepository);
        this.listener = new WebServiceListener((ISessionFactory)sessionFactory);
        this.server = new Server((Listener)this.listener, (IFeatureRepository)this.featureRepository, (IPromiseRepository)new PromiseRepository());
        this.featureRepository.addFeatureProfile((Profile)coreProfile);
    }

    @Override
    public void addFeatureProfile(Profile profile) {
        this.featureRepository.addFeatureProfile(profile);
    }

    @Override
    public void closeSession(UUID session) {
        this.server.closeSession(session);
    }

    @Override
    public void open(String host, int port, ServerEvents serverEvents) {
        this.server.open(host, port, serverEvents);
    }

    @Override
    public void close() {
        this.server.close();
    }

    @Override
    public boolean isClosed() {
        return this.listener.isClosed();
    }

    @Override
    public CompletionStage<Confirmation> send(UUID session, Request request) throws OccurenceConstraintException, UnsupportedFeatureException, NotConnectedException {
        return this.server.send(session, request);
    }
}

