/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.NotConnectedException;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;

public abstract class SOAPSyncHelper {
    private static final Logger logger = LoggerFactory.getLogger(SOAPSyncHelper.class);
    private HashMap<String, CompletableFuture<SOAPMessage>> promises = new HashMap();

    public static String getHeaderValue(SOAPMessage message, String tagName) {
        String value = null;
        try {
            SOAPHeader header = message.getSOAPPart().getEnvelope().getHeader();
            NodeList elements = header.getElementsByTagNameNS("*", tagName);
            if (elements.getLength() > 0) {
                value = elements.item(0).getChildNodes().item(0).getTextContent();
            }
        }
        catch (SOAPException e) {
            logger.warn("getHeaderValue() failed", (Throwable)e);
        }
        return value;
    }

    abstract void forwardMessage(SOAPMessage var1);

    public CompletableFuture<SOAPMessage> relay(SOAPMessage message) {
        CompletableFuture<SOAPMessage> promise = null;
        String uniqueID = SOAPSyncHelper.getHeaderValue(message, "MessageID");
        if (uniqueID != null) {
            promise = new CompletableFuture<SOAPMessage>();
            this.promises.put(uniqueID, promise);
        }
        this.forwardMessage(message);
        return promise;
    }

    abstract void sendRequest(SOAPMessage var1) throws NotConnectedException;

    public void send(Object message) throws NotConnectedException {
        SOAPMessage soapMessage = (SOAPMessage)message;
        String relatesTo = SOAPSyncHelper.getHeaderValue(soapMessage, "RelatesTo");
        if (relatesTo != null && this.promises.containsKey(relatesTo)) {
            this.promises.get(relatesTo).complete(soapMessage);
        } else {
            this.sendRequest(soapMessage);
        }
    }
}

