/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.ISession;
import eu.chargetime.ocpp.SessionEvents;
import eu.chargetime.ocpp.UnsupportedFeatureException;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.core.BootNotificationConfirmation;
import eu.chargetime.ocpp.model.core.RegistrationStatus;
import eu.chargetime.ocpp.utilities.TimeoutTimer;
import java.util.UUID;

public class TimeoutSessionDecorator
implements ISession {
    private TimeoutTimer timeoutTimer;
    private final ISession session;

    public TimeoutSessionDecorator(TimeoutTimer timeoutTimer, ISession session) {
        this.timeoutTimer = timeoutTimer;
        this.session = session;
    }

    private void resetTimer(int timeoutInSec) {
        if (this.timeoutTimer != null) {
            this.timeoutTimer.setTimeout((long)(timeoutInSec * 1000));
        }
        this.resetTimer();
    }

    private void resetTimer() {
        if (this.timeoutTimer != null) {
            this.timeoutTimer.reset();
        }
    }

    private void stopTimer() {
        if (this.timeoutTimer != null) {
            this.timeoutTimer.end();
        }
    }

    private void startTimer() {
        if (this.timeoutTimer != null) {
            this.timeoutTimer.begin();
        }
    }

    public UUID getSessionId() {
        return this.session.getSessionId();
    }

    public void open(String uri, SessionEvents eventHandler) {
        SessionEvents events = this.createEventHandler(eventHandler);
        this.session.open(uri, events);
    }

    public void accept(SessionEvents eventHandler) {
        SessionEvents events = this.createEventHandler(eventHandler);
        this.session.accept(events);
    }

    public String storeRequest(Request payload) {
        return this.session.storeRequest(payload);
    }

    public void sendRequest(String action, Request payload, String uuid) {
        this.session.sendRequest(action, payload, uuid);
    }

    public void close() {
        this.session.close();
    }

    private SessionEvents createEventHandler(final SessionEvents eventHandler) {
        return new SessionEvents(){

            public void handleConfirmation(String uniqueId, Confirmation confirmation) {
                TimeoutSessionDecorator.this.resetTimer();
                eventHandler.handleConfirmation(uniqueId, confirmation);
            }

            public synchronized Confirmation handleRequest(Request request) throws UnsupportedFeatureException {
                BootNotificationConfirmation bootNotification;
                TimeoutSessionDecorator.this.resetTimer();
                Confirmation confirmation = eventHandler.handleRequest(request);
                if (confirmation instanceof BootNotificationConfirmation && (bootNotification = (BootNotificationConfirmation)confirmation).getStatus() == RegistrationStatus.Accepted) {
                    TimeoutSessionDecorator.this.resetTimer(bootNotification.getInterval());
                }
                return confirmation;
            }

            public void handleError(String uniqueId, String errorCode, String errorDescription, Object payload) {
                eventHandler.handleError(uniqueId, errorCode, errorDescription, payload);
            }

            public void handleConnectionClosed() {
                eventHandler.handleConnectionClosed();
                TimeoutSessionDecorator.this.stopTimer();
            }

            public void handleConnectionOpened() {
                eventHandler.handleConnectionOpened();
                TimeoutSessionDecorator.this.startTimer();
            }
        };
    }
}

