/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import eu.chargetime.ocpp.SOAPMessageInfo;
import eu.chargetime.ocpp.WSHttpHandlerEvents;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSHttpHandler
implements HttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(WSHttpHandler.class);
    private String wsdlResourceName;
    private WSHttpHandlerEvents events;

    public WSHttpHandler(String wsdlResourceName, WSHttpHandlerEvents events) {
        this.wsdlResourceName = wsdlResourceName;
        this.events = events;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        if ("wsdl".equals(httpExchange.getRequestURI().getQuery())) {
            this.sendWSDL(httpExchange);
        } else {
            SOAPMessage request = this.parse(httpExchange.getRequestBody());
            SOAPMessage confirmation = this.events.incomingRequest(new SOAPMessageInfo(httpExchange.getRemoteAddress(), request));
            OutputStream responseStream = httpExchange.getResponseBody();
            try {
                httpExchange.getResponseHeaders().add("Content-Type", "application/soap+xml; charset=utf-8");
                httpExchange.sendResponseHeaders(200, 0L);
                confirmation.writeTo(responseStream);
            }
            catch (SOAPException e) {
                httpExchange.sendResponseHeaders(500, 0L);
                logger.warn("handle() confirmation.writeTo failed", (Throwable)e);
            }
            responseStream.close();
        }
    }

    private SOAPMessage parse(InputStream request) throws IOException {
        SOAPMessage message = null;
        try {
            MessageFactory messageFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
            message = messageFactory.createMessage(new MimeHeaders(), request);
        }
        catch (SOAPException e) {
            logger.warn("parse() failed", (Throwable)e);
        }
        return message;
    }

    private void sendWSDL(HttpExchange httpExchange) throws IOException {
        int read;
        InputStream wsdl = this.getClass().getClassLoader().getResourceAsStream(this.wsdlResourceName);
        httpExchange.sendResponseHeaders(200, 0L);
        OutputStream os = httpExchange.getResponseBody();
        byte[] buffer = new byte[2048];
        while ((read = wsdl.read(buffer)) != -1) {
            os.write(buffer, 0, read);
        }
        os.flush();
        os.close();
    }
}

