/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import com.sun.net.httpserver.HttpServer;
import eu.chargetime.ocpp.Communicator;
import eu.chargetime.ocpp.ISession;
import eu.chargetime.ocpp.ISessionFactory;
import eu.chargetime.ocpp.Listener;
import eu.chargetime.ocpp.ListenerEvents;
import eu.chargetime.ocpp.Radio;
import eu.chargetime.ocpp.SOAPCommunicator;
import eu.chargetime.ocpp.SOAPMessageInfo;
import eu.chargetime.ocpp.SOAPSyncHelper;
import eu.chargetime.ocpp.TimeoutSessionDecorator;
import eu.chargetime.ocpp.WSHttpHandler;
import eu.chargetime.ocpp.WSHttpHandlerEvents;
import eu.chargetime.ocpp.WebServiceReceiver;
import eu.chargetime.ocpp.model.SOAPHostInfo;
import eu.chargetime.ocpp.model.SessionInformation;
import eu.chargetime.ocpp.utilities.TimeoutHandler;
import eu.chargetime.ocpp.utilities.TimeoutTimer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceListener
implements Listener {
    private static final Logger logger = LoggerFactory.getLogger(WebServiceListener.class);
    private static final String WSDL_CENTRAL_SYSTEM = "eu/chargetime/ocpp/OCPP_CentralSystemService_1.6.wsdl";
    private final ISessionFactory sessionFactory;
    private ListenerEvents events;
    private String fromUrl = null;
    private HttpServer server;
    private boolean handleRequestAsync;
    private volatile boolean closed = true;

    public WebServiceListener(ISessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void open(String hostname, int port, ListenerEvents listenerEvents) {
        this.events = listenerEvents;
        this.fromUrl = String.format("http://%s:%d", hostname, port);
        try {
            this.server = HttpServer.create(new InetSocketAddress(hostname, port), 0);
            this.server.createContext("/", new WSHttpHandler(WSDL_CENTRAL_SYSTEM, new WSHttpEventHandler()));
            this.server.setExecutor(Executors.newCachedThreadPool());
            this.server.start();
            this.closed = false;
        }
        catch (IOException e) {
            logger.warn("open() failed", (Throwable)e);
        }
    }

    public void close() {
        if (this.server != null) {
            this.server.stop(1);
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setAsyncRequestHandler(boolean async) {
        this.handleRequestAsync = async;
    }

    private class WSHttpEventHandler
    implements WSHttpHandlerEvents {
        private static final long INITIAL_TIMEOUT = 300000L;
        HashMap<String, WebServiceReceiver> chargeBoxes = new HashMap();

        private void removeChargebox(String identity) {
            if (this.chargeBoxes.containsKey(identity)) {
                this.chargeBoxes.remove(identity);
            }
        }

        @Override
        public SOAPMessage incomingRequest(SOAPMessageInfo messageInfo) {
            SOAPMessage message = messageInfo.getMessage();
            final String identity = SOAPSyncHelper.getHeaderValue(message, "chargeBoxIdentity");
            if (!this.chargeBoxes.containsKey(identity)) {
                String toUrl = SOAPSyncHelper.getHeaderValue(message, "From");
                WebServiceReceiver webServiceReceiver = new WebServiceReceiver(toUrl, () -> this.removeChargebox(identity));
                SOAPHostInfo hostInfo = new SOAPHostInfo.Builder().isClient(false).chargeBoxIdentity(identity).fromUrl(WebServiceListener.this.fromUrl).namespace("urn://Ocpp/Cs/2015/10/").build();
                SOAPCommunicator communicator = new SOAPCommunicator(hostInfo, (Radio)webServiceReceiver);
                communicator.setToUrl(toUrl);
                final ISession session = WebServiceListener.this.sessionFactory.createSession((Communicator)communicator);
                TimeoutTimer timeoutTimer = new TimeoutTimer(300000L, new TimeoutHandler(){

                    public void timeout() {
                        session.close();
                        WSHttpEventHandler.this.chargeBoxes.remove(identity);
                    }
                });
                TimeoutSessionDecorator sessionDecorator = new TimeoutSessionDecorator(timeoutTimer, session);
                SessionInformation information = new SessionInformation.Builder().Identifier(identity).InternetAddress(messageInfo.getAddress()).SOAPtoURL(toUrl).build();
                WebServiceListener.this.events.newSession(session, information);
                this.chargeBoxes.put(identity, webServiceReceiver);
            }
            SOAPMessage confirmation = null;
            try {
                confirmation = this.chargeBoxes.get(identity).relay(message).get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.warn("incomingRequest() chargeBoxes.relay failed", (Throwable)e);
            }
            return confirmation;
        }
    }
}

