/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.NotConnectedException;
import eu.chargetime.ocpp.RadioEvents;
import eu.chargetime.ocpp.Receiver;
import eu.chargetime.ocpp.SOAPSyncHelper;
import eu.chargetime.ocpp.WebServiceReceiverEvents;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceReceiver
extends SOAPSyncHelper
implements Receiver {
    private static final Logger logger = LoggerFactory.getLogger(WebServiceReceiver.class);
    private RadioEvents events;
    private SOAPConnection soapConnection;
    private String url;
    private WebServiceReceiverEvents receiverEvents;
    private boolean connected;

    public WebServiceReceiver(String url, WebServiceReceiverEvents receiverEvents) {
        this.url = url;
        this.receiverEvents = receiverEvents;
        this.connected = false;
    }

    public void disconnect() {
        if (this.connected) {
            try {
                this.soapConnection.close();
                this.connected = false;
            }
            catch (SOAPException e) {
                logger.info("disconnect() failed", (Throwable)e);
            }
        }
        this.events.disconnected();
        this.receiverEvents.disconnect();
    }

    public boolean isClosed() {
        return !this.connected;
    }

    public void accept(RadioEvents events) {
        this.events = events;
        try {
            SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
            this.soapConnection = soapConnectionFactory.createConnection();
            this.connected = true;
            events.connected();
        }
        catch (SOAPException e) {
            logger.warn("accept() failed", (Throwable)e);
        }
    }

    @Override
    void forwardMessage(SOAPMessage message) {
        this.events.receivedMessage((Object)message);
    }

    @Override
    void sendRequest(final SOAPMessage message) throws NotConnectedException {
        if (!this.connected) {
            throw new NotConnectedException();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    WebServiceReceiver.this.events.receivedMessage((Object)WebServiceReceiver.this.soapConnection.call(message, (Object)WebServiceReceiver.this.url));
                }
                catch (SOAPException e) {
                    WebServiceReceiver.this.disconnect();
                }
            }
        }).start();
    }
}

