/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.NotConnectedException;
import eu.chargetime.ocpp.RadioEvents;
import eu.chargetime.ocpp.SOAPSyncHelper;
import eu.chargetime.ocpp.Transmitter;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceTransmitter
extends SOAPSyncHelper
implements Transmitter {
    private static final Logger logger = LoggerFactory.getLogger(WebServiceTransmitter.class);
    private SOAPConnection soapConnection;
    private String url;
    private RadioEvents events;
    private boolean connected = false;

    public void disconnect() {
        if (this.connected) {
            try {
                this.soapConnection.close();
                this.connected = false;
            }
            catch (SOAPException e) {
                logger.info("disconnect() failed", (Throwable)e);
            }
        }
        this.events.disconnected();
    }

    public boolean isClosed() {
        return !this.connected;
    }

    public void connect(String uri, RadioEvents events) {
        this.url = uri;
        this.events = events;
        try {
            SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
            this.soapConnection = soapConnectionFactory.createConnection();
            this.connected = true;
            events.connected();
        }
        catch (SOAPException e) {
            logger.warn("connect() failed", (Throwable)e);
        }
    }

    @Override
    protected void sendRequest(final SOAPMessage message) throws NotConnectedException {
        if (!this.connected) {
            throw new NotConnectedException();
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SOAPMessage response = WebServiceTransmitter.this.soapConnection.call(message, (Object)WebServiceTransmitter.this.url);
                    WebServiceTransmitter.this.events.receivedMessage((Object)response);
                }
                catch (SOAPException e) {
                    logger.warn("sendRequest() failed", (Throwable)e);
                    WebServiceTransmitter.this.disconnect();
                }
            }
        });
        thread.start();
    }

    @Override
    protected void forwardMessage(SOAPMessage message) {
        this.events.receivedMessage((Object)message);
    }
}

