/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.feature.profile;

import eu.chargetime.ocpp.feature.AuthorizeFeature;
import eu.chargetime.ocpp.feature.BootNotificationFeature;
import eu.chargetime.ocpp.feature.ChangeAvailabilityFeature;
import eu.chargetime.ocpp.feature.ChangeConfigurationFeature;
import eu.chargetime.ocpp.feature.ClearCacheFeature;
import eu.chargetime.ocpp.feature.DataTransferFeature;
import eu.chargetime.ocpp.feature.Feature;
import eu.chargetime.ocpp.feature.GetConfigurationFeature;
import eu.chargetime.ocpp.feature.HeartbeatFeature;
import eu.chargetime.ocpp.feature.MeterValuesFeature;
import eu.chargetime.ocpp.feature.ProfileFeature;
import eu.chargetime.ocpp.feature.RemoteStartTransactionFeature;
import eu.chargetime.ocpp.feature.RemoteStopTransactionFeature;
import eu.chargetime.ocpp.feature.ResetFeature;
import eu.chargetime.ocpp.feature.StartTransactionFeature;
import eu.chargetime.ocpp.feature.StatusNotificationFeature;
import eu.chargetime.ocpp.feature.StopTransactionFeature;
import eu.chargetime.ocpp.feature.UnlockConnectorFeature;
import eu.chargetime.ocpp.feature.profile.ClientCoreEventHandler;
import eu.chargetime.ocpp.feature.profile.Profile;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.core.AuthorizeRequest;
import eu.chargetime.ocpp.model.core.BootNotificationRequest;
import eu.chargetime.ocpp.model.core.ChangeAvailabilityRequest;
import eu.chargetime.ocpp.model.core.ChangeConfigurationRequest;
import eu.chargetime.ocpp.model.core.ChargePointErrorCode;
import eu.chargetime.ocpp.model.core.ChargePointStatus;
import eu.chargetime.ocpp.model.core.ClearCacheRequest;
import eu.chargetime.ocpp.model.core.DataTransferRequest;
import eu.chargetime.ocpp.model.core.GetConfigurationRequest;
import eu.chargetime.ocpp.model.core.HeartbeatRequest;
import eu.chargetime.ocpp.model.core.MeterValue;
import eu.chargetime.ocpp.model.core.MeterValuesRequest;
import eu.chargetime.ocpp.model.core.RemoteStartTransactionRequest;
import eu.chargetime.ocpp.model.core.RemoteStopTransactionRequest;
import eu.chargetime.ocpp.model.core.ResetRequest;
import eu.chargetime.ocpp.model.core.SampledValue;
import eu.chargetime.ocpp.model.core.StartTransactionRequest;
import eu.chargetime.ocpp.model.core.StatusNotificationRequest;
import eu.chargetime.ocpp.model.core.StopTransactionRequest;
import eu.chargetime.ocpp.model.core.UnlockConnectorRequest;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.UUID;

public class ClientCoreProfile
implements Profile {
    ArrayList<Feature> features = new ArrayList();
    private ClientCoreEventHandler eventHandler;

    public ClientCoreProfile(ClientCoreEventHandler handler) {
        this.eventHandler = handler;
        this.features.add((Feature)new AuthorizeFeature(null));
        this.features.add((Feature)new BootNotificationFeature(null));
        this.features.add((Feature)new ChangeAvailabilityFeature(this));
        this.features.add((Feature)new ChangeConfigurationFeature(this));
        this.features.add((Feature)new ClearCacheFeature(this));
        this.features.add((Feature)new DataTransferFeature(this));
        this.features.add((Feature)new GetConfigurationFeature(this));
        this.features.add((Feature)new HeartbeatFeature(null));
        this.features.add((Feature)new MeterValuesFeature(null));
        this.features.add((Feature)new RemoteStartTransactionFeature(this));
        this.features.add((Feature)new RemoteStopTransactionFeature(this));
        this.features.add((Feature)new ResetFeature(this));
        this.features.add((Feature)new StartTransactionFeature(null));
        this.features.add((Feature)new StatusNotificationFeature(null));
        this.features.add((Feature)new StopTransactionFeature(null));
        this.features.add((Feature)new UnlockConnectorFeature(this));
    }

    public AuthorizeRequest createAuthorizeRequest(String idTag) {
        return new AuthorizeRequest(idTag);
    }

    public BootNotificationRequest createBootNotificationRequest(String vendor, String model) {
        return new BootNotificationRequest(vendor, model);
    }

    public DataTransferRequest createDataTransferRequest(String vendorId) {
        return new DataTransferRequest(vendorId);
    }

    public HeartbeatRequest createHeartbeatRequest() {
        return new HeartbeatRequest();
    }

    public MeterValuesRequest createMeterValuesRequest(Integer connectorId, ZonedDateTime timestamp, String value) {
        SampledValue sampledValue = new SampledValue(value);
        return this.createMeterValuesRequest(connectorId, timestamp, sampledValue);
    }

    public MeterValuesRequest createMeterValuesRequest(Integer connectorId, ZonedDateTime timestamp, SampledValue ... sampledValues) {
        MeterValue meterValue = new MeterValue(timestamp, sampledValues);
        return this.createMeterValuesRequest(connectorId, meterValue);
    }

    public MeterValuesRequest createMeterValuesRequest(Integer connectorId, MeterValue ... meterValues) {
        MeterValuesRequest request = new MeterValuesRequest(connectorId);
        request.setMeterValue(meterValues);
        return request;
    }

    public StartTransactionRequest createStartTransactionRequest(Integer connectorId, String idTag, Integer meterStart, ZonedDateTime timestamp) {
        return new StartTransactionRequest(connectorId, idTag, meterStart, timestamp);
    }

    public StatusNotificationRequest createStatusNotificationRequest(Integer connectorId, ChargePointErrorCode errorCode, ChargePointStatus status) {
        StatusNotificationRequest request = new StatusNotificationRequest(connectorId, errorCode, status);
        return request;
    }

    public StopTransactionRequest createStopTransactionRequest(int meterStop, ZonedDateTime timestamp, int transactionId) {
        StopTransactionRequest request = new StopTransactionRequest(meterStop, timestamp, transactionId);
        return request;
    }

    public ProfileFeature[] getFeatureList() {
        return this.features.toArray(new ProfileFeature[0]);
    }

    public Confirmation handleRequest(UUID sessionIndex, Request request) {
        Object result = null;
        if (request instanceof ChangeAvailabilityRequest) {
            result = this.eventHandler.handleChangeAvailabilityRequest((ChangeAvailabilityRequest)request);
        } else if (request instanceof ChangeConfigurationRequest) {
            result = this.eventHandler.handleChangeConfigurationRequest((ChangeConfigurationRequest)request);
        } else if (request instanceof ClearCacheRequest) {
            result = this.eventHandler.handleClearCacheRequest((ClearCacheRequest)request);
        } else if (request instanceof DataTransferRequest) {
            result = this.eventHandler.handleDataTransferRequest((DataTransferRequest)request);
        } else if (request instanceof GetConfigurationRequest) {
            result = this.eventHandler.handleGetConfigurationRequest((GetConfigurationRequest)request);
        } else if (request instanceof RemoteStartTransactionRequest) {
            result = this.eventHandler.handleRemoteStartTransactionRequest((RemoteStartTransactionRequest)request);
        } else if (request instanceof RemoteStopTransactionRequest) {
            result = this.eventHandler.handleRemoteStopTransactionRequest((RemoteStopTransactionRequest)request);
        } else if (request instanceof ResetRequest) {
            result = this.eventHandler.handleResetRequest((ResetRequest)request);
        } else if (request instanceof UnlockConnectorRequest) {
            result = this.eventHandler.handleUnlockConnectorRequest((UnlockConnectorRequest)request);
        }
        return result;
    }
}

