/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.feature.profile;

import eu.chargetime.ocpp.feature.DiagnosticsStatusNotificationFeature;
import eu.chargetime.ocpp.feature.Feature;
import eu.chargetime.ocpp.feature.FirmwareStatusNotificationFeature;
import eu.chargetime.ocpp.feature.GetDiagnosticsFeature;
import eu.chargetime.ocpp.feature.ProfileFeature;
import eu.chargetime.ocpp.feature.UpdateFirmwareFeature;
import eu.chargetime.ocpp.feature.profile.ClientFirmwareManagementEventHandler;
import eu.chargetime.ocpp.feature.profile.Profile;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.firmware.DiagnosticsStatus;
import eu.chargetime.ocpp.model.firmware.DiagnosticsStatusNotificationRequest;
import eu.chargetime.ocpp.model.firmware.FirmwareStatus;
import eu.chargetime.ocpp.model.firmware.FirmwareStatusNotificationRequest;
import eu.chargetime.ocpp.model.firmware.GetDiagnosticsRequest;
import eu.chargetime.ocpp.model.firmware.UpdateFirmwareRequest;
import java.util.HashSet;
import java.util.UUID;

public class ClientFirmwareManagementProfile
implements Profile {
    private HashSet<Feature> features;
    private ClientFirmwareManagementEventHandler eventHandler;

    public ClientFirmwareManagementProfile(ClientFirmwareManagementEventHandler eventHandler) {
        this.eventHandler = eventHandler;
        this.features = new HashSet();
        this.features.add((Feature)new DiagnosticsStatusNotificationFeature(null));
        this.features.add((Feature)new FirmwareStatusNotificationFeature(null));
        this.features.add((Feature)new GetDiagnosticsFeature(this));
        this.features.add((Feature)new UpdateFirmwareFeature(this));
    }

    public DiagnosticsStatusNotificationRequest createDiagnosticsStatusNotificationRequest(DiagnosticsStatus status) {
        return new DiagnosticsStatusNotificationRequest(status);
    }

    public FirmwareStatusNotificationRequest createFirmwareStatusNotificationRequest(FirmwareStatus status) {
        return new FirmwareStatusNotificationRequest(status);
    }

    public ProfileFeature[] getFeatureList() {
        return this.features.toArray(new ProfileFeature[0]);
    }

    public Confirmation handleRequest(UUID sessionIndex, Request request) {
        Object result = null;
        if (request instanceof GetDiagnosticsRequest) {
            result = this.eventHandler.handleGetDiagnosticsRequest((GetDiagnosticsRequest)request);
        } else if (request instanceof UpdateFirmwareRequest) {
            result = this.eventHandler.handleUpdateFirmwareRequest((UpdateFirmwareRequest)request);
        }
        return result;
    }
}

