/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.feature.profile;

import eu.chargetime.ocpp.feature.CancelReservationFeature;
import eu.chargetime.ocpp.feature.Feature;
import eu.chargetime.ocpp.feature.ProfileFeature;
import eu.chargetime.ocpp.feature.ReserveNowFeature;
import eu.chargetime.ocpp.feature.profile.ClientReservationEventHandler;
import eu.chargetime.ocpp.feature.profile.Profile;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.reservation.CancelReservationRequest;
import eu.chargetime.ocpp.model.reservation.ReserveNowRequest;
import java.util.HashSet;
import java.util.UUID;

public class ClientReservationProfile
implements Profile {
    private HashSet<Feature> features;
    private ClientReservationEventHandler eventHandler;

    public ClientReservationProfile(ClientReservationEventHandler eventHandler) {
        this.eventHandler = eventHandler;
        this.features = new HashSet();
        this.features.add((Feature)new CancelReservationFeature(this));
        this.features.add((Feature)new ReserveNowFeature(this));
    }

    public ProfileFeature[] getFeatureList() {
        return this.features.toArray(new ProfileFeature[0]);
    }

    public Confirmation handleRequest(UUID sessionIndex, Request request) {
        Object result = null;
        if (request instanceof CancelReservationRequest) {
            result = this.eventHandler.handleCancelReservationRequest((CancelReservationRequest)request);
        } else if (request instanceof ReserveNowRequest) {
            result = this.eventHandler.handleReserveNowRequest((ReserveNowRequest)request);
        }
        return result;
    }
}

