/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.feature.profile;

import eu.chargetime.ocpp.feature.AuthorizeFeature;
import eu.chargetime.ocpp.feature.BootNotificationFeature;
import eu.chargetime.ocpp.feature.ChangeAvailabilityFeature;
import eu.chargetime.ocpp.feature.ChangeConfigurationFeature;
import eu.chargetime.ocpp.feature.ClearCacheFeature;
import eu.chargetime.ocpp.feature.DataTransferFeature;
import eu.chargetime.ocpp.feature.Feature;
import eu.chargetime.ocpp.feature.GetConfigurationFeature;
import eu.chargetime.ocpp.feature.HeartbeatFeature;
import eu.chargetime.ocpp.feature.MeterValuesFeature;
import eu.chargetime.ocpp.feature.ProfileFeature;
import eu.chargetime.ocpp.feature.RemoteStartTransactionFeature;
import eu.chargetime.ocpp.feature.RemoteStopTransactionFeature;
import eu.chargetime.ocpp.feature.ResetFeature;
import eu.chargetime.ocpp.feature.StartTransactionFeature;
import eu.chargetime.ocpp.feature.StatusNotificationFeature;
import eu.chargetime.ocpp.feature.StopTransactionFeature;
import eu.chargetime.ocpp.feature.UnlockConnectorFeature;
import eu.chargetime.ocpp.feature.profile.Profile;
import eu.chargetime.ocpp.feature.profile.ServerCoreEventHandler;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.core.AuthorizeRequest;
import eu.chargetime.ocpp.model.core.AvailabilityType;
import eu.chargetime.ocpp.model.core.BootNotificationRequest;
import eu.chargetime.ocpp.model.core.ChangeAvailabilityRequest;
import eu.chargetime.ocpp.model.core.ChangeConfigurationRequest;
import eu.chargetime.ocpp.model.core.ClearCacheRequest;
import eu.chargetime.ocpp.model.core.DataTransferRequest;
import eu.chargetime.ocpp.model.core.GetConfigurationRequest;
import eu.chargetime.ocpp.model.core.HeartbeatRequest;
import eu.chargetime.ocpp.model.core.MeterValuesRequest;
import eu.chargetime.ocpp.model.core.RemoteStartTransactionRequest;
import eu.chargetime.ocpp.model.core.RemoteStopTransactionRequest;
import eu.chargetime.ocpp.model.core.ResetRequest;
import eu.chargetime.ocpp.model.core.ResetType;
import eu.chargetime.ocpp.model.core.StartTransactionRequest;
import eu.chargetime.ocpp.model.core.StatusNotificationRequest;
import eu.chargetime.ocpp.model.core.StopTransactionRequest;
import eu.chargetime.ocpp.model.core.UnlockConnectorRequest;
import java.util.HashSet;
import java.util.UUID;

public class ServerCoreProfile
implements Profile {
    private ServerCoreEventHandler handler;
    private HashSet<Feature> features;

    public ServerCoreProfile(ServerCoreEventHandler handler) {
        this.handler = handler;
        this.features = new HashSet();
        this.features.add((Feature)new AuthorizeFeature(this));
        this.features.add((Feature)new BootNotificationFeature(this));
        this.features.add((Feature)new ChangeAvailabilityFeature(null));
        this.features.add((Feature)new ChangeConfigurationFeature(null));
        this.features.add((Feature)new ClearCacheFeature(null));
        this.features.add((Feature)new DataTransferFeature(this));
        this.features.add((Feature)new GetConfigurationFeature(null));
        this.features.add((Feature)new HeartbeatFeature(this));
        this.features.add((Feature)new MeterValuesFeature(this));
        this.features.add((Feature)new RemoteStartTransactionFeature(null));
        this.features.add((Feature)new RemoteStopTransactionFeature(null));
        this.features.add((Feature)new ResetFeature(null));
        this.features.add((Feature)new StartTransactionFeature(this));
        this.features.add((Feature)new StatusNotificationFeature(this));
        this.features.add((Feature)new StopTransactionFeature(this));
        this.features.add((Feature)new UnlockConnectorFeature(null));
    }

    public ProfileFeature[] getFeatureList() {
        return this.features.toArray(new ProfileFeature[0]);
    }

    public Confirmation handleRequest(UUID sessionIndex, Request request) {
        Object result = null;
        if (request instanceof AuthorizeRequest) {
            result = this.handler.handleAuthorizeRequest(sessionIndex, (AuthorizeRequest)request);
        } else if (request instanceof BootNotificationRequest) {
            result = this.handler.handleBootNotificationRequest(sessionIndex, (BootNotificationRequest)request);
        } else if (request instanceof DataTransferRequest) {
            result = this.handler.handleDataTransferRequest(sessionIndex, (DataTransferRequest)request);
        } else if (request instanceof HeartbeatRequest) {
            result = this.handler.handleHeartbeatRequest(sessionIndex, (HeartbeatRequest)request);
        } else if (request instanceof MeterValuesRequest) {
            result = this.handler.handleMeterValuesRequest(sessionIndex, (MeterValuesRequest)request);
        } else if (request instanceof StartTransactionRequest) {
            result = this.handler.handleStartTransactionRequest(sessionIndex, (StartTransactionRequest)request);
        } else if (request instanceof StatusNotificationRequest) {
            result = this.handler.handleStatusNotificationRequest(sessionIndex, (StatusNotificationRequest)request);
        } else if (request instanceof StopTransactionRequest) {
            result = this.handler.handleStopTransactionRequest(sessionIndex, (StopTransactionRequest)request);
        }
        return result;
    }

    public ChangeAvailabilityRequest createChangeAvailabilityRequest(AvailabilityType type, int connectorId) {
        return new ChangeAvailabilityRequest(connectorId, type);
    }

    public ChangeConfigurationRequest createChangeConfigurationRequest(String key, String value) {
        return new ChangeConfigurationRequest(key, value);
    }

    public ClearCacheRequest createClearCacheRequest() {
        return new ClearCacheRequest();
    }

    public DataTransferRequest createDataTransferRequest(String vendorId) {
        return new DataTransferRequest(vendorId);
    }

    public GetConfigurationRequest createGetConfigurationRequest() {
        return new GetConfigurationRequest();
    }

    public RemoteStartTransactionRequest createRemoteStartTransactionRequest(String idTag) {
        return new RemoteStartTransactionRequest(idTag);
    }

    public RemoteStopTransactionRequest createRemoteStopTransactionRequest(Integer transactionId) {
        return new RemoteStopTransactionRequest(transactionId);
    }

    public ResetRequest createResetRequest(ResetType type) {
        return new ResetRequest(type);
    }

    public UnlockConnectorRequest createUnlockConnectorRequest(int connectorId) {
        return new UnlockConnectorRequest(connectorId);
    }
}

