/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.feature.profile;

import eu.chargetime.ocpp.feature.DiagnosticsStatusNotificationFeature;
import eu.chargetime.ocpp.feature.Feature;
import eu.chargetime.ocpp.feature.FirmwareStatusNotificationFeature;
import eu.chargetime.ocpp.feature.GetDiagnosticsFeature;
import eu.chargetime.ocpp.feature.ProfileFeature;
import eu.chargetime.ocpp.feature.UpdateFirmwareFeature;
import eu.chargetime.ocpp.feature.profile.Profile;
import eu.chargetime.ocpp.feature.profile.ServerFirmwareManagementEventHandler;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.firmware.DiagnosticsStatusNotificationRequest;
import eu.chargetime.ocpp.model.firmware.FirmwareStatusNotificationRequest;
import eu.chargetime.ocpp.model.firmware.GetDiagnosticsRequest;
import eu.chargetime.ocpp.model.firmware.UpdateFirmwareRequest;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.UUID;

public class ServerFirmwareManagementProfile
implements Profile {
    private final ServerFirmwareManagementEventHandler eventHandler;
    private HashSet<Feature> features;

    public ServerFirmwareManagementProfile(ServerFirmwareManagementEventHandler eventHandler) {
        this.eventHandler = eventHandler;
        this.features = new HashSet();
        this.features.add((Feature)new GetDiagnosticsFeature(null));
        this.features.add((Feature)new DiagnosticsStatusNotificationFeature(this));
        this.features.add((Feature)new FirmwareStatusNotificationFeature(this));
        this.features.add((Feature)new UpdateFirmwareFeature(null));
    }

    public ProfileFeature[] getFeatureList() {
        return this.features.toArray(new ProfileFeature[0]);
    }

    public Confirmation handleRequest(UUID sessionIndex, Request request) {
        Object result = null;
        if (request instanceof DiagnosticsStatusNotificationRequest) {
            result = this.eventHandler.handleDiagnosticsStatusNotificationRequest(sessionIndex, (DiagnosticsStatusNotificationRequest)request);
        } else if (request instanceof FirmwareStatusNotificationRequest) {
            result = this.eventHandler.handleFirmwareStatusNotificationRequest(sessionIndex, (FirmwareStatusNotificationRequest)request);
        }
        return result;
    }

    public GetDiagnosticsRequest createGetDiagnosticsRequest(String location) {
        return new GetDiagnosticsRequest(location);
    }

    public UpdateFirmwareRequest createUpdateFirmwareRequest(String location, ZonedDateTime retrieveDate) {
        return new UpdateFirmwareRequest(location, retrieveDate);
    }
}

