/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model;

import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Objects;

public class SOAPHostInfo {
    public static final String NAMESPACE_CHARGEBOX = "urn://Ocpp/Cp/2015/10/";
    public static final String NAMESPACE_CENTRALSYSTEM = "urn://Ocpp/Cs/2015/10/";
    private String chargeBoxIdentity;
    private String fromUrl;
    private String toUrl;
    private String namespace;
    private boolean isClient;

    public String getChargeBoxIdentity() {
        return this.chargeBoxIdentity;
    }

    public String getFromUrl() {
        return this.fromUrl;
    }

    public String getToUrl() {
        return this.toUrl;
    }

    public void setToUrl(String toUrl) {
        this.toUrl = toUrl;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SOAPHostInfo that = (SOAPHostInfo)o;
        return this.isClient == that.isClient && Objects.equals(this.chargeBoxIdentity, that.chargeBoxIdentity) && Objects.equals(this.fromUrl, that.fromUrl) && Objects.equals(this.toUrl, that.toUrl) && Objects.equals(this.namespace, that.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.chargeBoxIdentity, this.fromUrl, this.toUrl, this.namespace, this.isClient);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("chargeBoxIdentity", (Object)this.chargeBoxIdentity).add("fromUrl", (Object)this.fromUrl).add("toUrl", (Object)this.toUrl).add("namespace", (Object)this.namespace).add("isClient", this.isClient).toString();
    }

    public static class Builder {
        private String chargeBoxIdentity;
        private String fromUrl;
        private String toUrl;
        private String namespace;
        private boolean isClient;

        public Builder chargeBoxIdentity(String chargeBoxIdentity) {
            if (chargeBoxIdentity == null) {
                throw new IllegalArgumentException("The object 'chargeBoxIdentity' cannot be null");
            }
            this.chargeBoxIdentity = chargeBoxIdentity;
            return this;
        }

        public Builder fromUrl(String fromUrl) {
            if (fromUrl == null) {
                throw new IllegalArgumentException("The object 'fromUrl' cannot be null");
            }
            this.fromUrl = fromUrl;
            return this;
        }

        public Builder toUrl(String toUrl) {
            if (toUrl == null) {
                throw new IllegalArgumentException("The object 'toUrl' cannot be null");
            }
            this.toUrl = toUrl;
            return this;
        }

        public Builder namespace(String namespace) {
            if (namespace == null) {
                throw new IllegalArgumentException("The object 'namespace' cannot be null");
            }
            this.namespace = namespace;
            return this;
        }

        public Builder isClient(boolean value) {
            this.isClient = value;
            return this;
        }

        public SOAPHostInfo build() {
            SOAPHostInfo res = new SOAPHostInfo();
            res.fromUrl = this.fromUrl;
            res.chargeBoxIdentity = this.chargeBoxIdentity;
            res.namespace = this.namespace;
            res.toUrl = this.toUrl;
            res.isClient = this.isClient;
            this.validate(res);
            return res;
        }

        private void validate(SOAPHostInfo hostInfo) {
            if (hostInfo.fromUrl == null || hostInfo.chargeBoxIdentity == null || hostInfo.namespace == null) {
                throw new IllegalStateException("Some required fields where not set.");
            }
        }
    }
}

