/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.utilities.ModelUtil;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class AuthorizeRequest
implements Request {
    private static final int IDTAG_MAX_LENGTH = 20;
    private static final String ERROR_MESSAGE = "Exceeded limit of 20 chars";
    private String idTag;

    @Deprecated
    public AuthorizeRequest() {
    }

    public AuthorizeRequest(String idTag) {
        this.setIdTag(idTag);
    }

    public String getIdTag() {
        return this.idTag;
    }

    @XmlElement
    public void setIdTag(String idTag) {
        if (!ModelUtil.validate((String)idTag, (int)20)) {
            throw new PropertyConstraintException((Object)idTag.length(), ERROR_MESSAGE);
        }
        this.idTag = idTag;
    }

    public boolean validate() {
        return ModelUtil.validate((String)this.idTag, (int)20);
    }

    public boolean transactionRelated() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizeRequest request = (AuthorizeRequest)o;
        return Objects.equals(this.idTag, request.idTag);
    }

    public int hashCode() {
        return Objects.hash(this.idTag);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("idTag", (Object)this.idTag).add("isValid", this.validate()).toString();
    }
}

