/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.core.RegistrationStatus;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="bootNotificationResponse")
@XmlType(propOrder={"status", "currentTime", "interval"})
public class BootNotificationConfirmation
implements Confirmation {
    private ZonedDateTime currentTime;
    private Integer interval;
    private RegistrationStatus status;

    @Deprecated
    public BootNotificationConfirmation() {
    }

    public BootNotificationConfirmation(ZonedDateTime currentTime, Integer interval, RegistrationStatus status) {
        this.setCurrentTime(currentTime);
        this.setInterval(interval);
        this.setStatus(status);
    }

    public ZonedDateTime getCurrentTime() {
        return this.currentTime;
    }

    @XmlElement
    public void setCurrentTime(ZonedDateTime currentTime) {
        this.currentTime = currentTime;
    }

    @Deprecated
    public ZonedDateTime objCurrentTime() {
        return this.currentTime;
    }

    public Integer getInterval() {
        return this.interval;
    }

    @XmlElement
    public void setInterval(Integer interval) {
        if (interval < 0) {
            throw new PropertyConstraintException((Object)interval, "interval be a positive value");
        }
        this.interval = interval;
    }

    @Deprecated
    public RegistrationStatus objStatus() {
        return this.status;
    }

    public RegistrationStatus getStatus() {
        return this.status;
    }

    @XmlElement
    public void setStatus(RegistrationStatus status) {
        this.status = status;
    }

    public boolean validate() {
        boolean valid = this.status != null;
        valid &= this.currentTime != null;
        return valid &= this.interval != null && this.interval >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BootNotificationConfirmation that = (BootNotificationConfirmation)o;
        return Objects.equals(this.interval, that.interval) && Objects.equals(this.currentTime, that.currentTime) && this.status == that.status;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.currentTime, this.interval, this.status});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("currentTime", this.currentTime).add("interval", (Object)this.interval).add("status", (Object)this.status).add("isValid", this.validate()).toString();
    }
}

