/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.utilities.ModelUtil;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"chargePointVendor", "chargePointModel", "chargePointSerialNumber", "chargeBoxSerialNumber", "firmwareVersion", "iccid", "imsi", "meterType", "meterSerialNumber"})
public class BootNotificationRequest
implements Request {
    private static final int STRING_20_CHAR_MAX_LENGTH = 20;
    private static final int STRING_25_CHAR_MAX_LENGTH = 25;
    private static final int STRING_50_CHAR_MAX_LENGTH = 50;
    private static final String ERROR_MESSAGE = "Exceeded limit of %s chars";
    private String chargePointVendor;
    private String chargePointModel;
    private String chargeBoxSerialNumber;
    private String chargePointSerialNumber;
    private String firmwareVersion;
    private String iccid;
    private String imsi;
    private String meterSerialNumber;
    private String meterType;

    @Deprecated
    public BootNotificationRequest() {
    }

    public BootNotificationRequest(String chargePointVendor, String chargePointModel) {
        this.setChargePointModel(chargePointModel);
        this.setChargePointVendor(chargePointVendor);
    }

    private static String validationErrorMessage(int maxAllowedLength) {
        return String.format(ERROR_MESSAGE, maxAllowedLength);
    }

    public String getChargePointVendor() {
        return this.chargePointVendor;
    }

    @XmlElement
    public void setChargePointVendor(String chargePointVendor) {
        if (!ModelUtil.validate((String)chargePointVendor, (int)20)) {
            throw new PropertyConstraintException((Object)chargePointVendor.length(), BootNotificationRequest.validationErrorMessage(20));
        }
        this.chargePointVendor = chargePointVendor;
    }

    public String getChargePointModel() {
        return this.chargePointModel;
    }

    @XmlElement
    public void setChargePointModel(String chargePointModel) {
        if (!ModelUtil.validate((String)chargePointModel, (int)20)) {
            throw new PropertyConstraintException((Object)chargePointModel.length(), BootNotificationRequest.validationErrorMessage(20));
        }
        this.chargePointModel = chargePointModel;
    }

    @Deprecated
    public String getChargeBoxSerialNumber() {
        return this.chargeBoxSerialNumber;
    }

    @Deprecated
    public void setChargeBoxSerialNumber(String chargeBoxSerialNumber) {
        if (!ModelUtil.validate((String)chargeBoxSerialNumber, (int)25)) {
            throw new PropertyConstraintException((Object)chargeBoxSerialNumber.length(), BootNotificationRequest.validationErrorMessage(25));
        }
        this.chargeBoxSerialNumber = chargeBoxSerialNumber;
    }

    public String getChargePointSerialNumber() {
        return this.chargePointSerialNumber;
    }

    @XmlElement
    public void setChargePointSerialNumber(String chargePointSerialNumber) {
        if (!ModelUtil.validate((String)chargePointSerialNumber, (int)25)) {
            throw new PropertyConstraintException((Object)chargePointSerialNumber.length(), BootNotificationRequest.validationErrorMessage(25));
        }
        this.chargePointSerialNumber = chargePointSerialNumber;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @XmlElement
    public void setFirmwareVersion(String firmwareVersion) {
        if (!ModelUtil.validate((String)firmwareVersion, (int)50)) {
            throw new PropertyConstraintException((Object)firmwareVersion.length(), BootNotificationRequest.validationErrorMessage(50));
        }
        this.firmwareVersion = firmwareVersion;
    }

    public String getIccid() {
        return this.iccid;
    }

    @XmlElement
    public void setIccid(String iccid) {
        if (!ModelUtil.validate((String)iccid, (int)20)) {
            throw new PropertyConstraintException((Object)iccid.length(), BootNotificationRequest.validationErrorMessage(20));
        }
        this.iccid = iccid;
    }

    public String getImsi() {
        return this.imsi;
    }

    @XmlElement
    public void setImsi(String imsi) {
        if (!ModelUtil.validate((String)imsi, (int)20)) {
            throw new PropertyConstraintException((Object)imsi.length(), BootNotificationRequest.validationErrorMessage(20));
        }
        this.imsi = imsi;
    }

    public String getMeterSerialNumber() {
        return this.meterSerialNumber;
    }

    @XmlElement
    public void setMeterSerialNumber(String meterSerialNumber) {
        if (!ModelUtil.validate((String)meterSerialNumber, (int)25)) {
            throw new PropertyConstraintException((Object)meterSerialNumber.length(), BootNotificationRequest.validationErrorMessage(25));
        }
        this.meterSerialNumber = meterSerialNumber;
    }

    public String getMeterType() {
        return this.meterType;
    }

    @XmlElement
    public void setMeterType(String meterType) {
        if (!ModelUtil.validate((String)meterType, (int)25)) {
            throw new PropertyConstraintException((Object)meterType.length(), BootNotificationRequest.validationErrorMessage(25));
        }
        this.meterType = meterType;
    }

    public boolean validate() {
        return ModelUtil.validate((String)this.chargePointModel, (int)20) && ModelUtil.validate((String)this.chargePointVendor, (int)20);
    }

    public boolean transactionRelated() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BootNotificationRequest that = (BootNotificationRequest)o;
        return Objects.equals(this.chargePointVendor, that.chargePointVendor) && Objects.equals(this.chargePointModel, that.chargePointModel) && Objects.equals(this.chargeBoxSerialNumber, that.chargeBoxSerialNumber) && Objects.equals(this.chargePointSerialNumber, that.chargePointSerialNumber) && Objects.equals(this.firmwareVersion, that.firmwareVersion) && Objects.equals(this.iccid, that.iccid) && Objects.equals(this.imsi, that.imsi) && Objects.equals(this.meterSerialNumber, that.meterSerialNumber) && Objects.equals(this.meterType, that.meterType);
    }

    public int hashCode() {
        return Objects.hash(this.chargePointVendor, this.chargePointModel, this.chargeBoxSerialNumber, this.chargePointSerialNumber, this.firmwareVersion, this.iccid, this.imsi, this.meterSerialNumber, this.meterType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("chargePointVendor", (Object)this.chargePointVendor).add("chargePointModel", (Object)this.chargePointModel).add("chargeBoxSerialNumber", (Object)this.chargeBoxSerialNumber).add("chargePointSerialNumber", (Object)this.chargePointSerialNumber).add("firmwareVersion", (Object)this.firmwareVersion).add("iccid", (Object)this.iccid).add("imsi", (Object)this.imsi).add("meterSerialNumber", (Object)this.meterSerialNumber).add("meterType", (Object)this.meterType).add("isValid", this.validate()).toString();
    }
}

