/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.utilities.ModelUtil;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"key", "value"})
public class ChangeConfigurationRequest
implements Request {
    private static final String ERROR_MESSAGE = "Exceeded limit of %s chars";
    private static final int KEY_MAX_LENGTH = 50;
    private static final int VALUE_MAX_LENGTH = 500;
    private String key;
    private String value;

    @Deprecated
    public ChangeConfigurationRequest() {
    }

    public ChangeConfigurationRequest(String key, String value) {
        this.setKey(key);
        this.setValue(value);
    }

    private static String createErrorMessage(int valueMaxLength) {
        return String.format(ERROR_MESSAGE, valueMaxLength);
    }

    public String getKey() {
        return this.key;
    }

    @XmlElement
    public void setKey(String key) {
        if (!this.isValidKey(key)) {
            throw new PropertyConstraintException((Object)key.length(), ChangeConfigurationRequest.createErrorMessage(50));
        }
        this.key = key;
    }

    private boolean isValidKey(String key) {
        return ModelUtil.validate((String)key, (int)50);
    }

    public String getValue() {
        return this.value;
    }

    @XmlElement
    public void setValue(String value) {
        if (!this.isValidValue(value)) {
            throw new PropertyConstraintException((Object)value.length(), ChangeConfigurationRequest.createErrorMessage(500));
        }
        this.value = value;
    }

    private boolean isValidValue(String value) {
        return ModelUtil.validate((String)value, (int)500);
    }

    public boolean validate() {
        return this.isValidKey(this.key) && this.isValidValue(this.value);
    }

    public boolean transactionRelated() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeConfigurationRequest that = (ChangeConfigurationRequest)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("value", (Object)this.value).add("isValid", this.validate()).toString();
    }
}

