/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Validatable;
import eu.chargetime.ocpp.model.core.ChargingProfileKindType;
import eu.chargetime.ocpp.model.core.ChargingProfilePurposeType;
import eu.chargetime.ocpp.model.core.ChargingSchedule;
import eu.chargetime.ocpp.model.core.RecurrencyKindType;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"chargingProfileId", "transactionId", "stackLevel", "chargingProfilePurpose", "chargingProfileKind", "recurrencyKind", "validFrom", "validTo", "chargingSchedule"})
public class ChargingProfile
implements Validatable {
    private Integer chargingProfileId;
    private Integer transactionId;
    private Integer stackLevel;
    private ChargingProfilePurposeType chargingProfilePurpose;
    private ChargingProfileKindType chargingProfileKind;
    private RecurrencyKindType recurrencyKind;
    private ZonedDateTime validFrom;
    private ZonedDateTime validTo;
    private ChargingSchedule chargingSchedule;

    @Deprecated
    public ChargingProfile() {
    }

    public ChargingProfile(Integer chargingProfileId, Integer stackLevel, ChargingProfilePurposeType chargingProfilePurpose, ChargingProfileKindType chargingProfileKind, ChargingSchedule chargingSchedule) {
        this.chargingProfileId = chargingProfileId;
        this.stackLevel = stackLevel;
        this.chargingProfilePurpose = chargingProfilePurpose;
        this.chargingProfileKind = chargingProfileKind;
        this.chargingSchedule = chargingSchedule;
    }

    @Deprecated
    public ChargingProfile(Integer chargingProfileId, Integer stackLevel, ChargingProfilePurposeType chargingProfilePurpose, ChargingProfileKindType chargingProfileKind) {
        this.chargingProfileId = chargingProfileId;
        this.stackLevel = stackLevel;
        this.chargingProfilePurpose = chargingProfilePurpose;
        this.chargingProfileKind = chargingProfileKind;
    }

    public boolean validate() {
        boolean valid = this.chargingProfileId != null;
        valid &= this.stackLevel != null && this.stackLevel >= 0;
        valid &= this.chargingProfilePurpose != null;
        valid &= this.transactionId == null || this.chargingProfilePurpose == ChargingProfilePurposeType.TxProfile;
        valid &= this.chargingProfileKind != null;
        return valid &= this.chargingSchedule != null && this.chargingSchedule.validate();
    }

    public Integer getChargingProfileId() {
        return this.chargingProfileId;
    }

    @XmlElement
    public void setChargingProfileId(Integer chargingProfileId) {
        if (chargingProfileId == null) {
            throw new PropertyConstraintException(null, "chargingProfileId must be present");
        }
        this.chargingProfileId = chargingProfileId;
    }

    public Integer getTransactionId() {
        return this.transactionId;
    }

    @XmlElement
    public void setTransactionId(Integer transactionId) {
        this.transactionId = transactionId;
    }

    public Integer getStackLevel() {
        return this.stackLevel;
    }

    @XmlElement
    public void setStackLevel(Integer stackLevel) {
        if (stackLevel == null || stackLevel < 0) {
            throw new PropertyConstraintException((Object)stackLevel, "stackLevel must be >= 0");
        }
        this.stackLevel = stackLevel;
    }

    public ChargingProfilePurposeType getChargingProfilePurpose() {
        return this.chargingProfilePurpose;
    }

    @XmlElement
    public void setChargingProfilePurpose(ChargingProfilePurposeType chargingProfilePurpose) {
        this.chargingProfilePurpose = chargingProfilePurpose;
    }

    @Deprecated
    public ChargingProfilePurposeType objChargingProfilePurpose() {
        return this.chargingProfilePurpose;
    }

    public ChargingProfileKindType getChargingProfileKind() {
        return this.chargingProfileKind;
    }

    @XmlElement
    public void setChargingProfileKind(ChargingProfileKindType chargingProfileKind) {
        this.chargingProfileKind = chargingProfileKind;
    }

    @Deprecated
    public ChargingProfileKindType objChargingProfileKind() {
        return this.chargingProfileKind;
    }

    public RecurrencyKindType getRecurrencyKind() {
        return this.recurrencyKind;
    }

    @XmlElement
    public void setRecurrencyKind(RecurrencyKindType recurrencyKind) {
        this.recurrencyKind = recurrencyKind;
    }

    @Deprecated
    public RecurrencyKindType objRecurrencyKind() {
        return this.recurrencyKind;
    }

    public ZonedDateTime getValidFrom() {
        return this.validFrom;
    }

    @XmlElement
    public void setValidFrom(ZonedDateTime validFrom) {
        this.validFrom = validFrom;
    }

    @Deprecated
    public ZonedDateTime objValidFrom() {
        return this.validFrom;
    }

    public ZonedDateTime getValidTo() {
        return this.validTo;
    }

    @XmlElement
    public void setValidTo(ZonedDateTime validTo) {
        this.validTo = validTo;
    }

    @Deprecated
    public ZonedDateTime objValidTo() {
        return this.validTo;
    }

    public ChargingSchedule getChargingSchedule() {
        return this.chargingSchedule;
    }

    @XmlElement
    public void setChargingSchedule(ChargingSchedule chargingSchedule) {
        this.chargingSchedule = chargingSchedule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChargingProfile that = (ChargingProfile)o;
        return Objects.equals(this.chargingProfileId, that.chargingProfileId) && Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.stackLevel, that.stackLevel) && this.chargingProfilePurpose == that.chargingProfilePurpose && this.chargingProfileKind == that.chargingProfileKind && this.recurrencyKind == that.recurrencyKind && Objects.equals(this.validFrom, that.validFrom) && Objects.equals(this.validTo, that.validTo) && Objects.equals(this.chargingSchedule, that.chargingSchedule);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.chargingProfileId, this.transactionId, this.stackLevel, this.chargingProfilePurpose, this.chargingProfileKind, this.recurrencyKind, this.validFrom, this.validTo, this.chargingSchedule});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("chargingProfileId", (Object)this.chargingProfileId).add("transactionId", (Object)this.transactionId).add("stackLevel", (Object)this.stackLevel).add("chargingProfilePurpose", (Object)this.chargingProfilePurpose).add("chargingProfileKind", (Object)this.chargingProfileKind).add("recurrencyKind", (Object)this.recurrencyKind).add("validFrom", this.validFrom).add("validTo", this.validTo).add("chargingSchedule", (Object)this.chargingSchedule).add("isValid", this.validate()).toString();
    }
}

