/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.model.Validatable;
import eu.chargetime.ocpp.model.core.ChargingRateUnitType;
import eu.chargetime.ocpp.model.core.ChargingSchedulePeriod;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"duration", "startSchedule", "chargingRateUnit", "chargingSchedulePeriod", "minChargingRate"})
public class ChargingSchedule
implements Validatable {
    private Integer duration;
    private ZonedDateTime startSchedule;
    private ChargingRateUnitType chargingRateUnit;
    private ChargingSchedulePeriod[] chargingSchedulePeriod;
    private Double minChargingRate;

    @Deprecated
    public ChargingSchedule() {
    }

    public ChargingSchedule(ChargingRateUnitType chargingRateUnit, ChargingSchedulePeriod[] chargingSchedulePeriod) {
        this.setChargingRateUnit(chargingRateUnit);
        this.setChargingSchedulePeriod(chargingSchedulePeriod);
    }

    public boolean validate() {
        boolean valid = this.chargingRateUnit != null;
        if (valid &= this.chargingSchedulePeriod != null) {
            for (ChargingSchedulePeriod period : this.chargingSchedulePeriod) {
                valid &= period.validate();
            }
        }
        return valid;
    }

    public Integer getDuration() {
        return this.duration;
    }

    @XmlElement
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public ZonedDateTime getStartSchedule() {
        return this.startSchedule;
    }

    @XmlElement
    public void setStartSchedule(ZonedDateTime startSchedule) {
        this.startSchedule = startSchedule;
    }

    @Deprecated
    public ZonedDateTime objStartSchedule() {
        return this.startSchedule;
    }

    public ChargingRateUnitType getChargingRateUnit() {
        return this.chargingRateUnit;
    }

    @XmlElement
    public void setChargingRateUnit(ChargingRateUnitType chargingRateUnit) {
        this.chargingRateUnit = chargingRateUnit;
    }

    @Deprecated
    public ChargingRateUnitType objChargingRateUnit() {
        return this.chargingRateUnit;
    }

    public ChargingSchedulePeriod[] getChargingSchedulePeriod() {
        return this.chargingSchedulePeriod;
    }

    @XmlElement
    public void setChargingSchedulePeriod(ChargingSchedulePeriod[] chargingSchedulePeriod) {
        this.chargingSchedulePeriod = chargingSchedulePeriod;
    }

    public Double getMinChargingRate() {
        return this.minChargingRate;
    }

    @XmlElement
    public void setMinChargingRate(Double minChargingRate) {
        this.minChargingRate = minChargingRate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChargingSchedule that = (ChargingSchedule)o;
        return Objects.equals(this.duration, that.duration) && Objects.equals(this.startSchedule, that.startSchedule) && this.chargingRateUnit == that.chargingRateUnit && Arrays.equals(this.chargingSchedulePeriod, that.chargingSchedulePeriod) && Objects.equals(this.minChargingRate, that.minChargingRate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.duration, this.startSchedule, this.chargingRateUnit, this.chargingSchedulePeriod, this.minChargingRate});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("duration", (Object)this.duration).add("startSchedule", this.startSchedule).add("chargingRateUnit", (Object)this.chargingRateUnit).add("chargingSchedulePeriod", (Object[])this.chargingSchedulePeriod).add("minChargingRate", (Object)this.minChargingRate).add("isValid", this.validate()).toString();
    }
}

