/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.utilities.ModelUtil;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"vendorId", "messageId", "data"})
public class DataTransferRequest
implements Request {
    private static final String ERROR_MESSAGE = "Exceeded limit of %s chars";
    private String vendorId;
    private String messageId;
    private String data;

    @Deprecated
    public DataTransferRequest() {
    }

    public DataTransferRequest(String vendorId) {
        this.vendorId = vendorId;
    }

    public boolean validate() {
        return this.isValidVendorId(this.vendorId);
    }

    public String getVendorId() {
        return this.vendorId;
    }

    @XmlElement
    public void setVendorId(String vendorId) {
        if (!this.isValidVendorId(vendorId)) {
            throw new PropertyConstraintException((Object)vendorId.length(), this.createErrorMessage(255));
        }
        this.vendorId = vendorId;
    }

    private boolean isValidVendorId(String vendorId) {
        return ModelUtil.validate((String)vendorId, (int)255);
    }

    public String getMessageId() {
        return this.messageId;
    }

    @XmlElement
    public void setMessageId(String messageId) {
        if (!this.isValidMessageId(messageId)) {
            throw new PropertyConstraintException((Object)messageId.length(), this.createErrorMessage(50));
        }
        this.messageId = messageId;
    }

    private boolean isValidMessageId(String messageId) {
        return ModelUtil.validate((String)messageId, (int)50);
    }

    public String getData() {
        return this.data;
    }

    @XmlElement
    public void setData(String data) {
        this.data = data;
    }

    public boolean transactionRelated() {
        return false;
    }

    private String createErrorMessage(int maxLength) {
        return String.format(ERROR_MESSAGE, maxLength);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTransferRequest that = (DataTransferRequest)o;
        return Objects.equals(this.vendorId, that.vendorId) && Objects.equals(this.messageId, that.messageId) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.vendorId, this.messageId, this.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("vendorId", (Object)this.vendorId).add("messageId", (Object)this.messageId).add("data", (Object)this.data).add("isValid", this.validate()).toString();
    }
}

