/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.core.KeyValueType;
import eu.chargetime.ocpp.utilities.ModelUtil;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Arrays;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="getConfigurationResponse")
@XmlType(propOrder={"configurationKey", "unknownKey"})
public class GetConfigurationConfirmation
implements Confirmation {
    private static final String ERROR_MESSAGE = "Exceeds limit of %s chars";
    private KeyValueType[] configurationKey;
    private String[] unknownKey;

    public KeyValueType[] getConfigurationKey() {
        return this.configurationKey;
    }

    @XmlElement
    public void setConfigurationKey(KeyValueType[] configurationKey) {
        this.configurationKey = configurationKey;
    }

    public String[] getUnknownKey() {
        return this.unknownKey;
    }

    @XmlElement
    public void setUnknownKey(String[] unknownKey) {
        this.isValidUnknownKey(unknownKey);
        this.unknownKey = unknownKey;
    }

    private void isValidUnknownKey(String[] unknownKeys) {
        for (String key : unknownKeys) {
            if (ModelUtil.validate((String)key, (int)50)) continue;
            throw new PropertyConstraintException((Object)key.length(), String.format(ERROR_MESSAGE, 50));
        }
    }

    private boolean validateConfigurationKeys() {
        boolean output = true;
        if (this.configurationKey != null && this.configurationKey.length > 0) {
            for (KeyValueType key : this.configurationKey) {
                if (key.validate()) continue;
                output = false;
                break;
            }
        }
        return output;
    }

    public boolean validate() {
        return this.validateConfigurationKeys();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetConfigurationConfirmation that = (GetConfigurationConfirmation)o;
        return Arrays.equals(this.configurationKey, that.configurationKey) && Arrays.equals(this.unknownKey, that.unknownKey);
    }

    public int hashCode() {
        return Objects.hash(this.configurationKey, this.unknownKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("configurationKey", (Object[])this.configurationKey).add("unknownKey", (Object[])this.unknownKey).add("isValid", this.validate()).toString();
    }
}

