/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.utilities.ModelUtil;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class GetConfigurationRequest
implements Request {
    private String[] key;

    public String[] getKey() {
        return this.key;
    }

    @XmlElement
    public void setKey(String[] key) {
        this.validateKeys(key);
        this.key = key;
    }

    private void validateKeys(String[] keys) {
        for (String k : keys) {
            if (ModelUtil.validate((String)k, (int)50)) continue;
            throw new PropertyConstraintException((Object)k.length(), "Exceeds limit of 50 chars");
        }
    }

    public boolean validate() {
        return true;
    }

    public boolean transactionRelated() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetConfigurationRequest that = (GetConfigurationRequest)o;
        return Arrays.equals(this.key, that.key);
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object[])this.key).add("isValid", this.validate()).toString();
    }
}

