/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Validatable;
import eu.chargetime.ocpp.utilities.ModelUtil;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"key", "readonly", "value"})
public class KeyValueType
implements Validatable {
    private static final String ERROR_MESSAGE = "Exceeds limit of %s chars";
    private String key;
    private Boolean readonly;
    private String value;

    @Deprecated
    public KeyValueType() {
    }

    public KeyValueType(String key, Boolean readonly) {
        this.setKey(key);
        this.setReadonly(readonly);
    }

    private static String createErrorMessage(int maxLength) {
        return String.format(ERROR_MESSAGE, maxLength);
    }

    public String getKey() {
        return this.key;
    }

    @XmlElement
    public void setKey(String key) {
        if (!this.isValidKey(key)) {
            throw new PropertyConstraintException((Object)key.length(), KeyValueType.createErrorMessage(50));
        }
        this.key = key;
    }

    private boolean isValidKey(String key) {
        return ModelUtil.validate((String)key, (int)50);
    }

    public Boolean getReadonly() {
        return this.readonly;
    }

    @XmlElement
    public void setReadonly(Boolean readonly) {
        if (!this.isValidReadonly(readonly)) {
            throw new PropertyConstraintException(null, "readonly must be present");
        }
        this.readonly = readonly;
    }

    private boolean isValidReadonly(Boolean readonly) {
        return readonly != null;
    }

    public String getValue() {
        return this.value;
    }

    @XmlElement
    public void setValue(String value) {
        if (!this.isValidValue(value)) {
            throw new PropertyConstraintException((Object)value.length(), KeyValueType.createErrorMessage(500));
        }
        this.value = value;
    }

    private boolean isValidValue(String value) {
        return ModelUtil.validate((String)value, (int)500);
    }

    public boolean validate() {
        return this.isValidKey(this.key) && this.isValidReadonly(this.readonly);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValueType that = (KeyValueType)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.readonly, that.readonly) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.readonly, this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("readonly", (Object)this.readonly).add("value", (Object)this.value).toString();
    }
}

