/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.model.Validatable;
import eu.chargetime.ocpp.model.core.SampledValue;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"timestamp", "sampledValue"})
public class MeterValue
implements Validatable {
    private ZonedDateTime timestamp;
    private SampledValue[] sampledValue;

    @Deprecated
    public MeterValue() {
    }

    public MeterValue(ZonedDateTime timestamp, SampledValue[] sampledValue) {
        this.setTimestamp(timestamp);
        this.setSampledValue(sampledValue);
    }

    public boolean validate() {
        boolean valid;
        boolean bl = valid = this.timestamp != null && this.sampledValue != null;
        if (valid) {
            for (SampledValue value : this.sampledValue) {
                valid &= value.validate();
            }
        }
        return valid;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    @XmlElement
    public void setTimestamp(ZonedDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @Deprecated
    public ZonedDateTime objTimestamp() {
        return this.timestamp;
    }

    public SampledValue[] getSampledValue() {
        return this.sampledValue;
    }

    @XmlElement
    public void setSampledValue(SampledValue[] sampledValue) {
        this.sampledValue = sampledValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeterValue that = (MeterValue)o;
        return Objects.equals(this.timestamp, that.timestamp) && Arrays.equals(this.sampledValue, that.sampledValue);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.sampledValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("timestamp", this.timestamp).add("sampledValue", (Object[])this.sampledValue).add("isValid", this.validate()).toString();
    }
}

