/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.core.MeterValue;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Arrays;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"connectorId", "transactionId", "meterValue"})
public class MeterValuesRequest
implements Request {
    private Integer connectorId;
    private Integer transactionId;
    private MeterValue[] meterValue;

    @Deprecated
    public MeterValuesRequest() {
    }

    public MeterValuesRequest(Integer connectorId) {
        this.setConnectorId(connectorId);
    }

    public boolean validate() {
        boolean valid;
        boolean bl = valid = this.connectorId != null && this.connectorId >= 0 && this.meterValue != null;
        if (valid) {
            for (MeterValue current : this.meterValue) {
                valid &= current != null && current.validate();
            }
        }
        return valid;
    }

    public Integer getConnectorId() {
        return this.connectorId;
    }

    @XmlElement
    public void setConnectorId(Integer connectorId) {
        if (connectorId < 0) {
            throw new PropertyConstraintException((Object)connectorId, "connectorId must be >= 0");
        }
        this.connectorId = connectorId;
    }

    public Integer getTransactionId() {
        return this.transactionId;
    }

    @XmlElement
    public void setTransactionId(Integer transactionId) {
        this.transactionId = transactionId;
    }

    public MeterValue[] getMeterValue() {
        return this.meterValue;
    }

    @XmlElement
    public void setMeterValue(MeterValue[] meterValue) {
        this.meterValue = meterValue;
    }

    public boolean transactionRelated() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeterValuesRequest that = (MeterValuesRequest)o;
        return Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.transactionId, that.transactionId) && Arrays.equals(this.meterValue, that.meterValue);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.transactionId, this.meterValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("transactionId", (Object)this.transactionId).add("meterValue", (Object[])this.meterValue).add("isValid", this.validate()).toString();
    }
}

