/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.model.core;

import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.core.ChargingProfile;
import eu.chargetime.ocpp.utilities.ModelUtil;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"connectorId", "idTag", "chargingProfile"})
public class RemoteStartTransactionRequest
implements Request {
    private Integer connectorId;
    private String idTag;
    private ChargingProfile chargingProfile;

    @Deprecated
    public RemoteStartTransactionRequest() {
    }

    public RemoteStartTransactionRequest(String idTag) {
        this.setIdTag(idTag);
    }

    public boolean validate() {
        boolean valid = ModelUtil.validate((String)this.idTag, (int)20);
        if (this.chargingProfile != null) {
            valid &= this.chargingProfile.validate();
        }
        if (this.connectorId != null) {
            valid &= this.connectorId > 0;
        }
        return valid;
    }

    public Integer getConnectorId() {
        return this.connectorId;
    }

    @XmlElement
    public void setConnectorId(Integer connectorId) {
        if (connectorId <= 0) {
            throw new PropertyConstraintException((Object)connectorId, "connectorId must be > 0");
        }
        this.connectorId = connectorId;
    }

    public String getIdTag() {
        return this.idTag;
    }

    @XmlElement
    public void setIdTag(String idTag) {
        if (!ModelUtil.validate((String)idTag, (int)20)) {
            throw new PropertyConstraintException((Object)idTag.length(), "Exceeded limit of 20 chars");
        }
        this.idTag = idTag;
    }

    public ChargingProfile getChargingProfile() {
        return this.chargingProfile;
    }

    @XmlElement
    public void setChargingProfile(ChargingProfile chargingProfile) {
        this.chargingProfile = chargingProfile;
    }

    public boolean transactionRelated() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteStartTransactionRequest that = (RemoteStartTransactionRequest)o;
        return Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.idTag, that.idTag) && Objects.equals(this.chargingProfile, that.chargingProfile);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.idTag, this.chargingProfile);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("idTag", (Object)this.idTag).add("chargingProfile", (Object)this.chargingProfile).add("isValid", this.validate()).toString();
    }
}

